#include "mbed.h"
#include "stm32l496g_discovery_lcd.h"
#include "stm32l496g_discovery_audio.h"
#include "SampledSoundDontTouch.h"

#define BSP_AUDIO_OUT_STEREOMODE        ((uint32_t)0x00000004) /* STEREO MODE          */
#define BSP_AUDIO_FREQUENCY_44K         SAI_AUDIO_FREQUENCY_44K  // Frequenza di campionamento
#define AUDIODATA_SIZE                      2   /* 16-bits audio data size */
#define DEFAULT_AUDIO_OUT_CHANNEL_NBR       ((uint8_t)2) // Stereo 2

// definizione durata note
#define SEMIBREVE 2000000 // durata della semibreve in microsecondi = 4sec
#define MINIMA SEMIBREVE/2  
#define SEMIMINIMA SEMIBREVE/4 
#define CROMA SEMIBREVE/8  
#define SEMICROMA CROMA/16  
#define BISCROMA SEMIBREVE/32 
#define SEMIBISCROMA SEMIBREVE/64 
#define SBRMIN SEMIBREVE+SEMIMINIMA
#define MINSEMIN MINIMA+SEMIMINIMA
#define SEMCROMA SEMIMINIMA+CROMA
#define SEMCROMCROM SEMICROMA+CROMA

// definizione della frequenza delle note ottava centrale del pianoforte
#define m 0
#define C4 261.63
#define C1d 277.18
#define D1b 277.18
#define D1 293.66
#define D1d 311.13
#define E1b 311.13
#define E1 329.63
#define F1 349.23
#define F1d 369.99
#define G1b 369.99
#define G4 392.0
#define G1d 415.3
#define A1b 415.3
#define A1 440.0
#define A1d 466.16
#define B1b 466.16
#define B1 493.18
#define F5 698.0
#define G5 784.0
#define E5b 622.0
#define C5 523.0
#define LA4 440.0
#define LA4d 466.0
#define D4 294.0
#define D4d 311.0
#define B4 494.0
#define F4 349.0
#define F4d 370.0
#define B4b 466.0
#define A4b 415.0
#define E4 330.0
#define C6 1046.0
#define C7 2093.0
#define B5 988.0
#define G7 3136.0
#define D6 1175.0
#define E4b 311.0
#define E5 659.0
#define G5 784.0
#define A5b 831.0
#define B5b 932.0
#define C8 4186.0
#define G4 392.0
#define F4d 370.0
#define C4d 277.0
#define A4d 466.0
#define C5d 554.0
#define F4d 370.0
#define F5d 698.0 
#define A4 440.0
#define D5 587.0
#define A5d 932.0
#define D5d 622.0

// numero di campioni che compongono un periodo della sinusoide in Output sull'ADC
#define SAMPLESINENUM   45// consigliabile avere  multipli di 45

// parametri dell'onda coseno da generare
#define PI        (3.141592653589793238462)
#define AMPLITUDE 32767 //(1.0)    // x * 3.3V
#define PHASE     (PI/2) // 2*pi è un periodo
#define OFFSET    32767 //(0x7FFF)

// numero di note componenti la scala diatonica
#define NUMTONE 120

// ticker per la generazione dell'onda con DAC
Ticker SampleOutTicker;

// Buffer contenente la sinusoide da porre in output.
unsigned short usaSine[SAMPLESINENUM];

// prototipo di funzione che genera i campioni della sinusoide da utilizzare per la generazione tramite DAC
void CalculateSinewave(void);
// cSoundWave = 0 for sine and = 1 for square
char cSoundWave;

void CalculateSinewave(int nOffset, int nAmplitude, double fPhase)
{
    // variabile contenente l'angolo in radianti
    double fRads;
    // indici per i cicli
    int nIndex;
    // passo in frequenza fissato dal numero di campioni in cui voglio dividere un periodo di sinusoide: DeltaF = 360°/NUMSAMPLE
    double fDeltaF;
    // angolo per il quale bisogna calcolare il valore di sinusoide: fAngle = nIndex*DeltaF
    double fAngle;
    
    // a seconda della selezione, genera una diversa forma d'onda
    // ATTENZIONE ----- SAREBBE MEGLIO CAMBIARE IL NOME DELL'ARRAY in usaWave[] !!!!! ----
    if(cSoundWave=='0')
    {
        // genera forma d'onda sinusoidale
        fDeltaF = 360.0/SAMPLESINENUM;
        for (nIndex = 0; nIndex < SAMPLESINENUM; nIndex++) 
        {
            fAngle = nIndex*fDeltaF; // angolo per il quale bisogna calcolare il campione di sinusoide
            fRads = (PI * fAngle)/180.0; // Convert degree in radian
            //usaSine[nIndex] = AMPLITUDE * cos(fRads + PHASE) + OFFSET;
            usaSine[nIndex] = nAmplitude * cos(fRads + fPhase) + nOffset;
        }
     }
     else
     {
        // genera forma d'onda quadra. 
        for (nIndex = 0; nIndex < SAMPLESINENUM/2; nIndex++) 
        {
            usaSine[nIndex] = nAmplitude*(1.0)+ nOffset;
        }
        for (nIndex = SAMPLESINENUM/2; nIndex < SAMPLESINENUM; nIndex++) 
        {
            usaSine[nIndex] = nAmplitude*(-1.0)+ nOffset;
        }
     }   
}


int main()
{
    BSP_LCD_Init();
   
    // indice per i cicli
    int nIndex;
                        
    // numero di note che compongono il brano
    #define WHENDURATION 32 // numero di note che compongono il brano
    // note del brano
    float fNoteWhen [WHENDURATION] = {D4, F4d, G4, A1, D4, F4d, G4, A1, D4, F4d, G4, A1, F4d,
    D4, F4d, E4, F4d, F4d, E4, D4, D4, F4d, A1, A1, G4, F4d, G4, A1, F4d, D4, E4, D4};
    // durata delle note del brano
    float fLengthWhen[WHENDURATION] ={SEMIMINIMA, SEMIMINIMA, SEMIMINIMA, SBRMIN, SEMIMINIMA,
    SEMIMINIMA, SEMIMINIMA, SBRMIN, SEMIMINIMA, SEMIMINIMA, SEMIMINIMA, MINIMA, MINIMA,
    MINIMA, MINIMA, SBRMIN, SEMIMINIMA, SEMIMINIMA, SEMIMINIMA, SBRMIN, SBRMIN, MINIMA, MINIMA, SEMIMINIMA,
    SBRMIN, SEMIMINIMA, SEMIMINIMA, MINIMA, MINIMA, MINIMA, MINIMA, SEMIBREVE};
    
    
    while(1) {
        BSP_LCD_SetFont(&Font12);
        BSP_LCD_Clear(LCD_COLOR_MAGENTA);
        BSP_LCD_SetBackColor(LCD_COLOR_MAGENTA);
        BSP_LCD_SetTextColor(LCD_COLOR_ORANGE);
        BSP_LCD_DisplayStringAt(0, LINE(4), (uint8_t *)"DISCO_L496AG", CENTER_MODE);
        BSP_LCD_DisplayStringAt(0, LINE(5), (uint8_t *)"VIOLATER", CENTER_MODE);
        BSP_LCD_DisplayStringAt(0, LINE(6), (uint8_t *)"WELCOME", CENTER_MODE);
        wait(2);
        BSP_LCD_SetFont(&Font16);
        BSP_LCD_Clear(LCD_COLOR_RED);
        BSP_LCD_SetBackColor(LCD_COLOR_RED);
        BSP_LCD_SetTextColor(LCD_COLOR_YELLOW);
        BSP_LCD_DisplayStringAt(0, LINE(4), (uint8_t *)"DISCO_L496AG", CENTER_MODE);
        BSP_LCD_DisplayStringAt(0, LINE(5), (uint8_t *)"VIOLATER", CENTER_MODE);
        BSP_LCD_DisplayStringAt(0, LINE(6), (uint8_t *)"WELCOME", CENTER_MODE);
        wait(2);
        BSP_LCD_SetFont(&Font20);
        BSP_LCD_Clear(LCD_COLOR_GREEN);
        BSP_LCD_SetBackColor(LCD_COLOR_GREEN);
        BSP_LCD_SetTextColor(LCD_COLOR_BLACK);
        BSP_LCD_DisplayStringAt(0, LINE(4), (uint8_t *)"DISCO_L496AG", CENTER_MODE);
        BSP_LCD_DisplayStringAt(0, LINE(5), (uint8_t *)"VIOLATER", CENTER_MODE);
        BSP_LCD_DisplayStringAt(0, LINE(6), (uint8_t *)"WELCOME", CENTER_MODE);
        wait(2);
        BSP_LCD_Clear(LCD_COLOR_BLUE);
        BSP_LCD_SetBackColor(LCD_COLOR_BLUE);
        BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
        BSP_LCD_SetFont(&Font24);
        BSP_LCD_DisplayStringAt(0, LINE(4), (uint8_t *)"DISCO_L496AG", CENTER_MODE);
        BSP_LCD_DisplayStringAt(0, LINE(5), (uint8_t *)"VIOLATER", CENTER_MODE);
        BSP_LCD_DisplayStringAt(0, LINE(6), (uint8_t *)"WHEN THE SAINT GO MARCHING IN", CENTER_MODE);
        wait(2);
        cSoundWave = 0;
        /* --- Inizio OLD ONE ----
        BSP_AUDIO_OUT_SetVolume(50.0);
        for(nIndex=0; nIndex<WHENDURATION; nIndex++)
        {
           BSP_AUDIO_OUT_Init( OUTPUT_DEVICE_HEADPHONE, 50.0, fNoteWhen[nIndex]);
           BSP_AUDIO_OUT_Init(OUTPUT_DEVICE_HEADPHONE, 100, BSP_AUDIO_FREQUENCY_22K);
           if (BSP_AUDIO_OUT_Stop != 0) 
            {
                BSP_AUDIO_OUT_Play((uint16_t *)OUTPUT_DEVICE_HEADPHONE, AUDIODATA_SIZE); // oppure fNoteWhen[nIndex]
            }
            wait_us(fLengthWhen[nIndex]);  
        }
        wait(2);
        --- Fine OLD ONE --- */
        //BSP_AUDIO_OUT_DeInit();
        BSP_AUDIO_OUT_Init(OUTPUT_DEVICE_HEADPHONE, 100, SAI_AUDIO_FREQUENCY_16K);
        BSP_AUDIO_OUT_ChangeAudioConfig(BSP_AUDIO_OUT_MONOMODE | BSP_AUDIO_OUT_NORMALMODE);
        BSP_AUDIO_OUT_Play((uint16_t*)&naInputSoundWaveDontTouch[0], 15403); // l'array generato è nel file SampledSoundDontTouch.h
        
        
    }                  //p.s. La funzione per il vecchio amplificatore SampleOut per la lettura della sinusoide non funziona

}
