// pilotaggio carrello tramite BLE.
// testato su L476RG e F401RE

#include "mbed.h"
#include<stdlib.h>

// dimensione massima del pacchetto ricevuto su seriale
#define PACKETDIM   8


// Definizione periferica USB seriale del PC
Serial pc(USBTX, USBRX, 921600); // seriale di comunicazione con il PC. Associati a PA_11 e PA_12

// Definizione periferica seriale del Modulo BLE ELETT114A
Serial myBLE(PA_9, PA_10, 9600); //Tx, Rx, bps // F401
//Serial myBLE(PG_7, PG_8, 9600); //Tx, Rx, bps // L496

// Input di Reset per il Modulo BLE HC-05
DigitalOut BleRst(PA_8);

// User Button, LED  
DigitalIn myButton(USER_BUTTON); // pulsante Blu sulla scheda. Associato a PC_13
DigitalOut myLed(LED2); // LED verde sulla scheda. Associato a PA_5


//carattere di comando ricevuto dal BLE e relativo parametro
volatile char cCommandBLE; // cambia nella routine di interrupt
volatile char cParamBLE; // cambia nella routine di interrupt
volatile int nParamBLE; // corrispondente valore numerico di cParamBLE

// memorizza l'ultimo comando ricevuto e relativo parametro. Ci saranno delle azioni solo se il comando ricevuto o il parametro è cambiato rispetto al precedente
char cOldCommandBLE;
int nOldParamBLE; 

 // indice per i cicli
int nIndex;

// esponente della base 10, per cui bisognerà moltiplicare i caratteri per trasformarli in numeri
double fEsponente;

// array per la ricezione dei messaggi da BLE
volatile char caRxPacket[PACKETDIM]; 
// contatore di caratteri ricevuti daBLE
volatile int nCharCount; 

// flag che indica se il sw è in Reset
volatile bool bReset;

/**************************************************************************************/
/* Routine di gestione Interrupt associata al fronte di salita del segnale di encoder */
/**************************************************************************************/



//**********************************************/
//          IRQ associata a Rx da BLE 
//**********************************************/
void BLERxInterrupt(void)
{
    
    // carattere ricevuto da BLE
    char cReadChar; 
    
    while(myBLE.readable())
    {
        // acquisice stringa in input e memorizza in array
        cReadChar = myBLE.getc(); // Read character
        //caRxPacket[nCharCount]=cReadChar;
        //nCharCount++;
        //pc.printf("%c", cReadChar); // diagnostica
        
        // +++++++++++++++++ INIZIO gestione Comando da Button +++++++++++++++++
        // Ho ricevuto il comando da un Button se il primo carattere è una lettera maiuscola tra 'A' e 'Z' oppure tra 'a' e 'z'
        if(((cReadChar > 0x40) && (cReadChar < 0x5A)) || ((cReadChar > 0x61) && (cReadChar < 0x7A))) // caratteri alfabetici da 'A' a 'T'
        {
            // memorizza come comando il carattere appena letto
            cCommandBLE = cReadChar; 
        }
        // +++++++++++++++++ FINE gestione Comando da Button +++++++++++++++++
    }
}




/*********************************************************************************************************************************************/
/* ogni DELTAT secondi scatta questo ticker.                                                                                                 */
/* Tra due Tick viene contato il numero di mpulsi impulsi di encoder ricevuti con degli interrupt e contentuo nella variabile nCountRiseEdge */
/*********************************************************************************************************************************************/

/**********/
/*  MAIN  */
/**********/
int main()
{    
    // messaggio di benvenuto
    pc.printf("\r\n************  CLM ****************** \r\n");
    pc.printf("*** Campanella Amaldi ***\r\n");
    myBLE.printf("***W Campanella Amaldi ***\r\n");
    
    // inizializza variabili da BLE
    cCommandBLE = 0; // inizialmente nessun comando da BLE
     cOldCommandBLE = 0; // inizialmente nessun comando da BLE
   
    // Attiva la IRQ per la RX su seriale   
    myBLE.attach(&BLERxInterrupt,Serial::RxIrq); // // entra in questa routine quando riceve un carattere dalla seriale del BLE
                
     
    //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    //++++++++++++++ INIZIO Ciclo Principale +++++++++++++++++++    
    //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        
    while(true)
    {
    
        //++++++++++++++++++++++++++ INIZIO Interpreta Comandi da Pulsanti della APP ++++++++++++++++++++++++++++++++++++++++++++
        if(cCommandBLE != cOldCommandBLE)
        {       
            switch (cCommandBLE)
            { 
                case 'I': // entrata
                { 
                    pc.printf("Acceso Messaggio Entrata\n\r"); 
                } break;
                case 'i': // entrata
                { 
                    pc.printf("Spento Messaggio Entrata\n\r"); 
                } break;
                case 'R': // Cambio
                {   
                    pc.printf("Acceso Messaggio Cambio\n\r"); 
                } break;
                case 'r': // Cambio
                {   
                    pc.printf("Spento Messaggio Cambio\n\r"); 
                } break;
    
                case 'U': // Uscita
                {    
                    pc.printf("Acceso Messaggio Uscite\n\r"); 
                } break;
                case 'u': // Uscita
                {    
                    pc.printf("Spento Messaggio Uscite\n\r"); 
                } break;
                
                default: break;
            }
            // ricorda di aver già compiuto l'operazione e non la ripetere fino a ricezione nuovo comando
            cOldCommandBLE = cCommandBLE;
        }
        
        
        //++++++++++++++++++++++++++++++++++++++++++++ FINE Interpreta Comandi da Pulsanti della APP ++++++++++++++++++++++++++++++++++++++++++++++++++++++
    } //while (true) Ciclo principale
    
    //++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    //++++++++++++++ FINE Ciclo Principale  +++++++++++++++++++    
    //+++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    
} // main()
