// pilotaggio carrello tramite BLE.
// testato su L476RG e F401RE

#include "mbed.h"
#include<stdlib.h>

// dimensione massima del pacchetto ricevuto su seriale
#define PACKETDIM   8


// Definizione periferica USB seriale del PC
Serial pc(USBTX, USBRX, 921600); // seriale di comunicazione con il PC. Associati a PA_11 e PA_12

// Definizione periferica seriale del Modulo BLE ELETT114A
Serial myBLE(PA_9, PA_10, 9600); //Tx, Rx, bps // F401
//Serial myBLE(PG_7, PG_8, 9600); //Tx, Rx, bps // L496

// Input di Reset per il Modulo BLE HC-05
DigitalOut BleRst(PA_8);

// User Button, LED  
DigitalIn myButton(USER_BUTTON); // pulsante Blu sulla scheda. Associato a PC_13
DigitalOut myLed(LED2); // LED verde sulla scheda. Associato a PA_5


//carattere di comando ricevuto dal BLE e relativo parametro
volatile char cCommandBLE; // cambia nella routine di interrupt
volatile char cParamBLE; // cambia nella routine di interrupt
volatile int nParamBLE; // corrispondente valore numerico di cParamBLE

// memorizza l'ultimo comando ricevuto e relativo parametro. Ci saranno delle azioni solo se il comando ricevuto o il parametro è cambiato rispetto al precedente
char cOldCommandBLE;
int nOldParamBLE; 

 // indice per i cicli
int nIndex;

// esponente della base 10, per cui bisognerà moltiplicare i caratteri per trasformarli in numeri
double fEsponente;

// array per la ricezione dei messaggi da BLE
volatile char caRxPacket[PACKETDIM]; 
// contatore di caratteri ricevuti daBLE
volatile int nCharCount; 

// flag che indica se il sw è in Reset
volatile bool bReset;

/**************************************************************************************/
/* Routine di gestione Interrupt associata al fronte di salita del segnale di encoder */
/**************************************************************************************/

/**********************************************/
//          IRQ associata a Rx da PC 
//**********************************************/
void pcRxInterrupt(void)
{
    // array per la ricezione dei messaggi da seriale
    char cReadChar; 
    
    // ricevi caratteri su seriale, se disponibili   
    while((pc.readable()))
    {
        // acquisice stringa in input e relativa dimensione
        cReadChar = pc.getc(); // read character from PC
        //myBLE.putc(cReadChar); // Diagnostica: write char to BLE
        //pc.putc(cReadChar); // Diagnostica: write char to PC
        
        //pc.printf("W>: 0x%02x\n\r",cReadChar); // diagnostica
       /* if(cReadChar == '0') // se scrivo '0', invia questa stringa
        {
            // DIAGNOSTICA:
            // Invia Stringa di comando al Robot
            myBLE.printf("\r\n> Prova di Trasmissione \r\n");
         }*/
    }
}

//**********************************************/
//          IRQ associata a Rx da BLE 
//**********************************************/
void BLERxInterrupt(void)
{
    
    // carattere ricevuto da BLE
    char cReadChar; 
    
    while((myBLE.readable()))
    {
        // acquisice stringa in input e memorizza in array
        cReadChar = myBLE.getc(); // Read character
        //caRxPacket[nCharCount]=cReadChar;
        //nCharCount++;
       // pc.printf("%c", cReadChar); // diagnostica
        
        // acquisisce il carattere di start comando o coordinate da APP
        if(cReadChar=='(')
        {
            // acquisisce il primo carattere di comando o di coordinate
            cReadChar = myBLE.getc(); // Read character       
           // pc.printf("%c", cReadChar); // diagnostica 
            
            // +++++++++++++++++ INIZIO gestione Comando da Button +++++++++++++++++
            // Ho ricevuto il comando da un Button se il primo carattere è una lettera maiuscola tra A e T
            if((cReadChar > 0x40) && (cReadChar < 0x55)) // caratteri alfabetici da 'A' a 'T'
            {
                // memorizza come comando il carattere appena letto
                cCommandBLE = cReadChar; 
                // legge e memorizza come paramentro il successivo carattere
                cReadChar = myBLE.getc(); // legge parametro
              //  pc.printf("%c", cReadChar); // diagnostica 
                nParamBLE = cReadChar-0x30;
                cReadChar = myBLE.getc(); // legge la ')' di chiusura comando       
                //pc.printf("%c", cReadChar); // diagnostica 

                // visualizza comando e parametro inviato da BLE
               // pc.printf("> %c%d \r\n\r",cCommandBLE, nParamBLE); // diagnostica
                if(cReadChar==')') 
                    {
                        //pc.printf("(fX , fY) = (%.1f , %.1f) \r\n", fX, fY); // diagnostica
                    }
                    else // dopo la Y e i numeri, mi attendo parentesi chiusa )
                    {
                        pc.printf("> Errore = %c invece di ) \r\n\n", cReadChar); // diagnostica
                    }
            }
            // +++++++++++++++++ FINE gestione Comando da Button +++++++++++++++++
        } // if(cReadChar == '(')
    }// chiude il while
}




/*********************************************************************************************************************************************/
/* ogni DELTAT secondi scatta questo ticker.                                                                                                 */
/* Tra due Tick viene contato il numero di mpulsi impulsi di encoder ricevuti con degli interrupt e contentuo nella variabile nCountRiseEdge */
/*********************************************************************************************************************************************/

/**********/
/*  MAIN  */
/**********/
int main()
{    
    // messaggio di benvenuto
    pc.printf("\r\n************  CLM ****************** \r\n");
    pc.printf("*** Campanella Amaldi ***\r\n");
    myBLE.printf("***W Campanella Amaldi ***\r\n");
    
    // inizializza variabili da BLE
    cCommandBLE = 0; // inizialmente nessun comando da BLE
    cOldCommandBLE = 0; // inizialmente nessun comando da BLE
    cParamBLE = 0;  // inizialmente nessun parametro da BLE
    nParamBLE=0;    // inizialmente nessun parametro da BLE
    nOldParamBLE=0; // inizialmente nessun parametro da BLE
    bReset = false; //bReset = true/false quando riceve un comando (R1)/(R0) dalla APP
    
    // inizializza array di caratteri ricevuti
    for(nIndex=0; nIndex < PACKETDIM; nIndex++)
     {caRxPacket[nIndex]=0;}
    nCharCount=0;                   
     
    //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    //++++++++++++++ INIZIO Ciclo Principale +++++++++++++++++++    
    //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        
    while(true)
    {
    
        //++++++++++++++++++++++++++ INIZIO Interpreta Comandi da Pulsanti della APP ++++++++++++++++++++++++++++++++++++++++++++
               
        if((cCommandBLE != cOldCommandBLE) || (nParamBLE != nOldParamBLE))
        {
            switch (cCommandBLE)
            { 
                case 'A': // entrata
                { 
                    if(nParamBLE==1)
                    {
                        myBLE.printf("Entrate\n\r"); 
                    }
                    else
                    {
                    }  
                } break;
                case 'B': // Cambio
                {   
                    if(nParamBLE==1)
                    {
                        pc.printf("Cambio\n\r"); 
                    }
                    else
                    {
                    }  
                } break;
                case 'C': // Uscita
                {    
                    if(nParamBLE==1)
                    {
                        pc.printf("Uscite\n\r"); 
                    }
                    else
                    {
                    }  
                } break;
                
                default: break;
            }
            //pc.printf("Comando = %c, Parametro = %d \r\n", cCommandBLE, nParamBLE); // diagnostica
            cOldCommandBLE = cCommandBLE;
            nOldParamBLE = nParamBLE;
        }
        
        //++++++++++++++++++++++++++++++++++++++++++++ FINE Interpreta Comandi da Pulsanti della APP ++++++++++++++++++++++++++++++++++++++++++++++++++++++
    } //while (true) Ciclo principale
    
    //++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    //++++++++++++++ FINE Ciclo Principale  +++++++++++++++++++    
    //+++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    
} // main()
