// Tested: NUCLEO-F207ZG
#include "mbed.h"

// numero di acqusizioni su cui effettuare la media della temperatura
#define NUMSAMPLE 300

AnalogIn InWave(PC_0);
Serial pc(USBTX, USBRX);


// Output LED di diagnostica
DigitalOut led1(LED1); // verde
DigitalOut led2(LED2); // blu
DigitalOut led3(LED3); // rosso


// ticker per l'acquisizione dell'onda con ADC
Ticker SamplingTicker;

// carattere in arrivo dal PC ed equivalente numerico
volatile char cReadChar;
volatile int nReadChar;

// flag che diventa true quando si vuole fermare l'acquisizione
volatile bool bStop;

// valore letto dall'ADC e corrispondente in tensione
volatile unsigned short usReadADC;
volatile float fReadVoltage;

// valore di temperatura letto dall'ADC
volatile float fTemp;
 
//***************************
// Acquisizione da ADC
//***************************
void Sampling() 
{
    // indice per i cicli
    int nIndex;
    // valore medio della temperatura su NUMACQUISISIONI acquisizioni
    float fAvgTemp;
    
    // se è stato inviato il comando Stop, non fare niente fino a nuovo comando
    if(bStop)
    {
    }
    else // se non è stato inviato il comando di bStop continua
    {
        // inizializza il valore medio della temperatura 
        fAvgTemp=0.0;
        for(nIndex=0; nIndex < NUMSAMPLE; nIndex++)
        {
            // acquisisce dato da ADC
            usReadADC = InWave.read_u16();
            fReadVoltage=(usReadADC*3.3)/65535.0; // converte in Volt il valore numerico letto dall'ADC
            //fReadVoltage=InWave.read(); // acquisisce il valore dall'ADC come valore di tensione in volt
            fTemp= ((fReadVoltage-0.25)*100.0)/(3.05-0.25); //applica la formula della retta tra i valori minimo e massimo del sensore
            fAvgTemp+=fTemp;
        }   
        // calcola valore medio su NUMSAMPLE acquisizioni 
        fAvgTemp/= NUMSAMPLE;
        
        // accendi LED in base a superamento soglie
        if (fAvgTemp <= 30.0)
        {
            // accendi LED Blu sotto i 28°
            led1=0;
            led2=1;
            led3=0;
        }
        else
        {
            if(fAvgTemp >= 32.0)
            {
                    // accendi LED Rosso sopra i 32°
                    led1=0;
                    led2=0;
                    led3=1;
            }
            else
            {
                // accendi LED verde tra 28 e 30
                led1=1;
                led2=0;
                led3=0;
            }
        }
        
        
        
        
        // invia il dato al PC
        //pc.printf("\n\r--- Voltage= %.1f [Volt]; Temperature= %.1f [Celsius] ---\n\r", fReadVoltage, fTemp);
        pc.printf("\n\r--- Digital= %d [Volt]; Temperature= %.2f [Celsius] ---\n\r", usReadADC, fTemp);
        
        
        
        /*
        // prepara il pacchetto di dati acquisiti  da restituire al PC
        caTxPacket[nSampleInCount]= (char)(usReadADC&0xFF);
        //+++caTxPacket[nSampleInCount]= 'a';
        nSampleInCount++;
        caTxPacket[nSampleInCount] = (char)((usReadADC>>8)&0xFF);
        //++++caTxPacket[nSampleInCount]= 'b';
        */
          
     }
}




 //*******************
 // Loop Principale
 //*******************  
int main()
{
    // periodo di campionamento
    int nDeltaT;
    
       
    // configura velocità della comunicazione seriale su USB-VirtualCom e invia messaggio di benvenuto
    pc.baud(921600); //921600 bps
    // messaggio di benvenuto
    pc.printf("\r\nHallo Amaldi Students - Exercise 7 \r\n");
    pc.printf("\r\n*** Bluetooth Temp Acquisition ***\r\n");
    
    // inizializza variabili
    bStop=true;
    
    // test dei LED
    led1=1; //Verde
    wait_ms(1000);
    led1=0;
    led2=1; // Blu
    wait_ms(1000);
    led2=0;
    led3=1; //Rosso
    wait_ms(1000);
    led3=0;
    
   
    
    while(true) 
    {
        // verifica se è arrivato un carattere dalla seriale del PC
        if(pc.readable())
        {
            cReadChar = pc.getc(); // Read hyperterminal
                    
            if((cReadChar == 'S') || (cReadChar == 's')) // blocca acquisizione se riceve 'S' oppure 's'
            {
                bStop= true;
                pc.printf("\n\r--- Acquisition Stopped ---\n\r");
            }    
            if((cReadChar >= '0') && (cReadChar <='9'))
            {
                bStop = false;
                nReadChar = cReadChar -'0'; //converte il carattere acquisito dal PC nel corrispondente valore numerico
                nDeltaT = nReadChar; // sampling Period in sec
                pc.printf("\n\r--- Acquisition Started DeltaT = %c ---\n\r", cReadChar);
                SamplingTicker.attach(&Sampling,nDeltaT);
            }
                    
        } //lettura da pc    
    } // while(true)
}














