//Tested: NUCLEO-F401RE
#include "mbed.h"

/****************** START BLE Declaration ****************/
#include "ble/BLE.h"
#include "LEDService.h"

DigitalOut Led1(LED1);
DigitalOut myLED(PB_2);
DigitalOut myRelay(PA_15);
DigitalIn myButton(USER_BUTTON);
Serial pc(USBTX, USBRX); 


const static char     DEVICE_NAME[] = "Amaldi_Ex_5";
static const uint16_t uuid16_list[] = {LEDService::LED_SERVICE_UUID};

LEDService *ledServicePtr;
/***************** END BLE Declaration ********************/

/**************** START BLE Functions **********************/

//****************************************************************
//* Disconnection Callback
//****************************************************************
void disconnectionCallback(const Gap::DisconnectionCallbackParams_t *params)
{
    (void)params;
    BLE::Instance().gap().startAdvertising(); // restart advertising
    
     pc.printf("------ Sono qui 3 disconnetrionCallBack \r\n", error);
}

//****************************************************************************************
//* This callback allows the LEDService to receive updates to the ledState Characteristic.
//*
//* @param[in] params
//*     Information about the characterisitc being updated.
//****************************************************************************************
void onDataWrittenCallback(const GattWriteCallbackParams *params) 
{
    if ((params->handle == ledServicePtr->getValueHandle()) && (params->len == 1)) 
    {
        
        //*switch(*(params->data))
        /*Led1 = *(params->data); // in params->data riceve il byte inviato dal cellulare
        {
       
            case ?:
            {
                
            } break;
            
            default: break;
        }*/
        pc.printf("\n\r---- Ricevuto: %d \n\r",*(params->data));
        
        //Led1 = *(params->data); // in params->data riceve il byte inviato dal cellulare
    }
}

//************************************************************************** 
//* This function is called when the ble initialization process has failled 
//************************************************************************** 
void onBleInitError(BLE &ble, ble_error_t error) 
{ 
    /* Initialization error handling should go here */ 
} 

//************************************************************************** 
//* Callback triggered when the ble initialization process has finished 
//************************************************************************** 
void bleInitComplete(BLE::InitializationCompleteCallbackContext *params) 
{
    BLE&        ble   = params->ble;
    ble_error_t error = params->error;

    if (error != BLE_ERROR_NONE) 
    {
        /* In case of error, forward the error handling to onBleInitError */
        onBleInitError(ble, error);
        return;
    }

    /* Ensure that it is the default instance of BLE */
    if(ble.getInstanceID() != BLE::DEFAULT_INSTANCE) 
    {
        return;
    }

    ble.gap().onDisconnection(disconnectionCallback);
    ble.gattServer().onDataWritten(onDataWrittenCallback);

    bool initialValueForLEDCharacteristic = true;
    ledServicePtr = new LEDService(ble, initialValueForLEDCharacteristic);

    /* setup advertising */
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED | GapAdvertisingData::LE_GENERAL_DISCOVERABLE);
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LIST_16BIT_SERVICE_IDS, (uint8_t *)uuid16_list, sizeof(uuid16_list));
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LOCAL_NAME, (uint8_t *)DEVICE_NAME, sizeof(DEVICE_NAME));
    ble.gap().setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED);
    ble.gap().setAdvertisingInterval(1000); // 1000ms.
    ble.gap().startAdvertising();

    while (true) 
    {
        ble.waitForEvent();
        //pc.printf("-------- Sono qui 1 WaitForEvent() \n\r");
    }
}
/******************* END BLE Functions *************************/


/********/
/* MAIN */
/********/
int main(void)
{
    // configura velocità della comunicazione seriale su USB-VirtualCom e invia messaggio di benvenuto
    pc.baud(921600); //921600 bps
    // messaggio di benvenuto
    pc.printf("\r\nHallo Amaldi Students - Exercise 5 \r\n");
    pc.printf("\r\n*** Bluetooth Driving for LED and Relay ***\r\n");
    
    //imposta il funzionamento del pulsante come "PullDown": Aperto = '0'. L'altra modalità di funzinamento è PullUp
    myButton.mode(PullDown);
    
    /* ciclo di prova 
    while(true)
    {
        if(myButton==0x01)
        {
            myLED=0x01;
            //while(myButton !=0x00);
            Led1=0x01;
            myRelay=0x01; // accendi relay
        }
        else
        {
            myLED=0x00;
            Led1=0x00;
            myRelay=0x00; // spegni relay
        }
    }
    */
    /*************** START BLE Main ************/
    BLE &ble = BLE::Instance();
    ble.init(bleInitComplete);
    /*************** END BLE Main ***********/
    
    
    
}

