#include "mbed.h"

// inizializza oggetti
InterruptIn myButton(USER_BUTTON);
DigitalOut myLed(LED1);

// dichiara variabile. Inizialmente delay lunghissimo
double dDelay = 2000; // 2 sec


/*************************************************************/
/* Routine di gestione Interrupt associata al button pressed */
/*************************************************************/
void pressedIRQ()
{
    // assegna valore alla variabile dDelay che sarà poi usata nel Main per generare un ritardo
    dDelay = 100; // 100 ms
}

/**************************************************************/
/* Routine di gestione Interrupt associata al button released */
/**************************************************************/
void releasedIRQ()
{
    // assegna valore alla variabile dDelay che sarà poi usata nel Main per generare un ritardo
    dDelay = 500; // 500 ms
}


/********/
/* MAIN */
/********/
int main()
{
    
    // Associa routine di Interrup all'evento Button premuto
    myButton.fall(&pressedIRQ); // Ogni volta che premo Button viene richiamata la routine pressedIRQ 
    // Associa routine di Interrup all'evento Button rilasciato
    myButton.rise(&releasedIRQ);

    // POLLING: accende/spegne il LED con un ritardo diverso a seconda che sia premuto/rilasciato il pulsante
    while (true)
    {
        // accende/spegne il LED
        myLed = !myLed;
        
        // Il delay dipende dalla posizione Pressed/Released del pulsante
        wait_ms(dDelay);
        
        // posso aumentare la precisione del ritardo impostandolo in usec
        //wait_us(dDelay);
    }
}
