// mbed specific header files.
#include "mbed.h"

#include "Arrivederci.h"
#include "CambioOra.h"
#include "PrestoInClasse.h"
#include "Welcome.h"
#include "TooDark.h"


// dimensione massima del pacchetto ricevuto su seriale
#define PACKETDIM   8


// Input/Output utilizzati da funzioni default su scheda NUCLEO
DigitalOut myOnBoardLed(LED2);// LED verde sulla scheda. Associato a PA_5
Serial pc(SERIAL_TX, SERIAL_RX,9600); // seriale di comunicazione con il PC. Associati a PA_11 e PA_12
DigitalIn myOnBoardButton(USER_BUTTON); // pulsante Blu sulla scheda. Associato a PC_13

// Definizione periferica seriale del Modulo BLE HC05
Serial myBLE(PA_9, PA_10, 9600); //Tx, Rx, bps


// inizializza variabili contenente comando da BLE
volatile char cCommandBLE = 0; // ultimo comando ricevuto tramite BLE
volatile char cOldCommandBLE = 0; // precedente comando ricevuto tramite BLE

// pacchetto di dati e relativa dimensione, ricevuto tramite BLE
char volatile caRxPacket[PACKETDIM]; // variabile che viene modificata e aggiornata nella IRQ della BLE

//indice e contatore di caratteri ricevuti da BLE
volatile int nCharCount; // variabile che viene modificata e aggiornata nella IRQ della BLE

// flag che diventa true quando si accende la luce
bool bLuce = false;
        
DigitalOut myRelay (PC_7); // pin di output verso il secondo relay
AnalogOut myWaveOut (PA_4); // uscita analogica Audio
AnalogIn myPhotoTrans (PA_1); // input analogico per phototransistor


// funzione per generare messaggi vocali
//void SoundMessage(array in in put, numero di campioni nell'array in input, ritardo nella generazione tra un campione e l'altro)
void SoundMessage(const int naInputSoundWave[], int nSampleNum, long fSampleDeltaT);

/*******************************************/
/* Funzione di generazione Messaggio Audio */
/*******************************************/
void SoundMessage(const int naInputSoundWave[],int nSampleNum, long fSampleDeltaT)
{
    // indice per i cicli interni alla funzione
    int nIndex;
    
    
    //++++++++++++ INIZIO generazione messaggio +++++++++++++++++ 
    for(nIndex=0; nIndex < nSampleNum; nIndex++)
    {
        // mette in output un campione della forma d'onda del welcome message  moltiplicato per l'amplificazione fAmp
        myWaveOut.write_u16(naInputSoundWave[nIndex]);
        
        // tra un campione e l'altro attendi un periodo pari al periodo di campionamento
        wait_us(fSampleDeltaT); // 57; 37 quando non sottocampionato
    }
    //++++++++++++ FINE generazione messaggio +++++++++++++++++
}


//**********************************************/
//          IRQ associata a Rx da BLE 
//**********************************************/
void BLERxInterrupt(void)
{
    // carattere ricevuto da BLE
    char cReadChar; 
    
    //myOnBoardLed = !myOnBoardLed;
    
    
    while((myBLE.readable()))
    {
        // acquisice stringa in input e memorizza in array
        cReadChar = myBLE.getc(); // Read character
        caRxPacket[nCharCount]=cReadChar;
        nCharCount++;
        pc.printf("%c\r\n", cReadChar); // diagnostica
        
        if(cReadChar != NULL)
        {
            // assegna il carattere ricevuto, al comando da BLE
            cCommandBLE = cReadChar;
        } 
    }
 }
     
/********/
/* Main */
/********/
int main()
{
    // messaggio di benvenuto
    pc.printf("\r\n*****     Hallo Amaldi Students - Exercise 40     *****\r\n");
    pc.printf("*****              Electronic Bell             *****\r\n");
    
    // inizializza variabili
    myOnBoardLed = 0;
    myRelay = 0;
    bLuce = false;
        
        
    // Attiva la IRQ per la RX su seriale BLE
    myBLE.attach(&BLERxInterrupt,Serial::RxIrq); // // entra in questa routine quando riceve un carattere dalla seriale del BLE
   
    
    //+++++++++++++++++++
    //+ Ciclo Principale 
    //+++++++++++++++++++
    while(true)
    {
        pc.printf("%.3f\r\n",myPhotoTrans.read());
        if((myPhotoTrans.read() < 0.1) && (bLuce==false))
        {
            myRelay = 1;
            SoundMessage(naInputSoundWaveTooDark,nSampleNumTooDark, 70.0); // genera messaggio audio di Ingresso
            bLuce = true;
        }
        if(myPhotoTrans.read() > 0.5)
        {
            myRelay = 0;
            bLuce = false;
        }
        // se è arrivato un comando diverso dal precedente, applica le azioni richieste
        if(cCommandBLE != cOldCommandBLE)
        {
            
            switch (cCommandBLE)
            {
                // accendi/spegni la luce
                case 'L': // 'A' = 0x41; 'a' = 0x61
                {
                    myOnBoardLed = 1;
                    myRelay = 1;
                } break;
                case 'l': 
                {
                    myOnBoardLed = 0;
                    myRelay = 0;
                    bLuce = false; // riattiva il flag per accendere la luce in caso di superamento soglia di bassa luminosità
                } break;
                case 'I': // 'A' = 0x41; 'a' = 0x61
                {
                    myOnBoardLed = 1;
                    SoundMessage(naInputSoundWavePrestoInClasse,nSampleNumPrestoInClasse, 62.0); // genera messaggio audio di Ingresso
                } break;
                case 'i': 
                {
                    myOnBoardLed = 0;
                    SoundMessage(naInputSoundWavePrestoInClasse,0, 0.0); // spegni il messaggio audio
                } break;
                case 'R': // 'A' = 0x41; 'a' = 0x61
                {
                    myOnBoardLed = 1;
                    SoundMessage(naInputSoundWaveCambioOra,nSampleNumCambioOra, 65.0); // genera messaggio audio di Ricreazione
                } break;
                case 'r': 
                {
                    myOnBoardLed = 0;
                    SoundMessage(naInputSoundWaveCambioOra,0, 0.0); // spegni il messaggio audio
                } break;
                case 'U': // 'A' = 0x41; 'a' = 0x61
                {
                    myOnBoardLed = 1;
                    SoundMessage(naInputSoundWaveArrivederci,nSampleNumArrivederci, 67.0); // genera messaggio audio di Uscita
                } break;
                case 'u': 
                {
                    myOnBoardLed = 0;
                    SoundMessage(naInputSoundWaveArrivederci,0, 0.0); // spegni il messaggio audio
                } break;
                case 'B': // 'A' = 0x41; 'a' = 0x61
                {
                    myOnBoardLed = 1;
                    SoundMessage(naInputSoundWaveWelcome,nSampleNumWelcome, 40.0); // genera messaggio audio di benvenuto
                } break;
                case 'b': 
                {
                    myOnBoardLed = 0;
                    SoundMessage(naInputSoundWaveWelcome,0, 0.0); // spegni il messaggio audio
                } break;
                default: {} break;
                
            }
            // visualizza il comando ricevuto 
            pc.printf("Comando = %c \r\n", cCommandBLE); // diagnostica
            cOldCommandBLE = cCommandBLE; // memorizza il comando ricevuto
        }
    }
}

  