// Tested: NUCLE-L476RG

#include "mbed.h"

// crea oggetti Button, LED e serialPC  
DigitalIn myButton(USER_BUTTON);
DigitalOut myLed(LED1);
Serial pc(USBTX, USBRX); 


/********/
/* MAIN */
/********/
int main() 
{
  // imposta velocità della comunicazione con il PC
  pc.baud(921600);
  
  //imposta il funzionamento del pulsante come "PullDown": Aperto = '0'. L'altra modalità di funzinamento è PullUp
  myButton.mode(PullDown);
  
  // POLLING: replica sul LED myLED lo stato del pulsante myButton
  while(true) 
  {
    if (myButton == 1) 
    { 
        // Button is pressed
        myLed = 1; // Accendi LED
    }
    else 
    {
        // Button i released
        myLed = 0; // Spegni LED
    }
  }
}
 