// Tested: NUCLEO-L476RG

#include "mbed.h"

Serial pc(USBTX, USBRX);
DigitalOut myLed (LED1);

/**************************************/
/* Routine di Gestione Interrupt IRQ  */
/**************************************/
void myInterrupt()
{
    char key;
    
    // cattura carattere da seriale
    key = pc.getc();
    
    // invia stringa al PC
    pc.printf("Interrupted %c\r\n", key);
}

/********/
/* MAIN */
/********/
int main() 
{
    // inizializza seriale
    pc.baud(921600);
    
    // inizializza variabili
    myLed=0;
    
    // messaggio di benvenuto
    pc.printf("\r\nHallo Amaldi Students - Exercise 2 \r\n");
    
    // inizializza routine interrupt
    pc.attach(myInterrupt, Serial::RxIrq);
    
    // accendi/spegni LED mentre attende Rx da seriale per gestire la IRQ
    while(1)
    {
        // inverte lo stato acceso/spento del LED
        myLed=!myLed;   
    }
}
