// bpilotaggio carrello tramite BLE.
// testato su L476RG

#include "mbed.h"
#include<stdlib.h>

// pi greco
#define PI           3.14159265358979323846

// Definizione periferica USB seriale del PC
Serial pc(USBTX, USBRX, 921600); // seriale di comunicazione con il PC. Associati a PA_11 e PA_12

// Definizione periferica seriale del Modulo BLE ELETT114A
Serial myBLE(PA_9, PA_10, 115200); //Tx, Rx, bps

// Input di Reset per il Modulo BLE ELETT114A.
DigitalOut BleRst(PA_8);

// User Button, LED  
DigitalIn myButton(USER_BUTTON); // pulsante Blu sulla scheda. Associato a PC_13
DigitalOut myLed(LED2); // LED verde sulla scheda. Associato a PA_5




// carattere letto dalla seriale del PC
char cReadChar;

// DutyCycle del segnale PWM
float fDutyCycle;


// Input/Output
DigitalOut PostOutBI1 (PA_6);  // Output 1 per pilotaggio input BI1 del Motore B Posteriore
PwmOut PostOutPWB (PA_7);  // Output per pilotaggio input PWM del motore B Posteriore
//DigitalOut PostOutPWB (PA_7);  // Scopi Diagnostici: Output Digitale per pilotaggio PWM del motore B Posteriore
DigitalOut PostOutBI2 (PB_6);  // Output 2 per pilotaggio input BI2 del Motore B Posteriore
DigitalIn PostInNE1 (PC_7); // Input per acquisire i segnali NET1 in output dall'encoder Posteriore

//DigitalInOut OutBlades (PB_9, PIN_OUTPUT, OpenDrain, 0); // Output per il pilotaggio del Relay di azionamento Lame Rotanti


DigitalOut AntOutBI1 (PB_4);  // Output 1 per pilotaggio input BI1 del Motore B Anteriore
PwmOut AntOutPWB (PB_5);  // Output per pilotaggio input PWM del motore B Anteriore
//DigitalOut AntOutPWB (PB_5);  // Scopi diagnostici: Output Digitalte per pilotaggio PWM del motore B Anteriore
DigitalOut AntOutBI2 (PB_3);  // Output 2 per pilotaggio input BI2 del Motore B Posteriore
DigitalIn AntInNE1 (PB_10); // Input per acquisire i segnali NET1 in output dall'encoder Anteriore



//carattere di comando ricevuto dal BLE
volatile char cCommandBLE; // cambia nella routine di interrupt
// memorizza l'ultimo comando ricevuto. Ci saranno delle azioni solo se il comando ricevuto è cambiato rispetto al precedente
char cOldCommandBLE;

// coordinate polari del joistick sulla APP, fornite dalla routine di interrupt
volatile double fTeta;
volatile double fRo;

// coordinate cartesiane della posizione joystick sulla APP, fornite dalla routine di Interrupt
volatile double fX, fY;
// memorizza ultimi valori delle coordinate del joistick
double fOldX, fOldY;

// variabili ausiliarie per l'algoritmo di posizionamento
double fV, fW;

// velocità della ruota sinistra e della ruota destra. La Sinistra coincide con la ruota Anteriore, la destra con la Posteriore
double fR, fL;





//**********************************************/
//          IRQ per la Rx su BLE 
//**********************************************/
void BLERxInterrupt(void)
{
    // array per la ricezione dei messaggi da seriale
    char cReadChar;
    
    //indice per i cicli
    int nIndex;
    
    // array per la ricezione dei messaggi da seriale
    char caRxPacket[8];
    //int nRxPacketSize;
    
    // coordinate cartesiane della posizione joystick
    //float fX, fY;
    // coordinate polari della posizione joistick
    //float fTeta;
    //float fRo;
    
    
   
    //pc.printf("BLE RxInterrupt: \n\r");
    
    // ricevi caratteri su seriale, se disponibili   
    while((myBLE.readable()))
    {
        // acquisice stringa in input e relativa dimensione
        cReadChar = myBLE.getc(); // Read character
        if(cReadChar == 0x02)
        {
            
            caRxPacket[0] = cReadChar; // legge e memorizza il primo carattere STX
            cReadChar = myBLE.getc(); // legge il secondo carattere
            if(cReadChar > 0x40)
            {
               caRxPacket[1] = cReadChar; // memorizza il secondo carattere. Contiene il Comando dal Button della APP
                caRxPacket[2] = myBLE.getc();  // legge e memorizza il terzo carattere ETX
                // passa il comando ricevuto nella variabile globale
                cCommandBLE = caRxPacket[1];
                
               
            }    
            else
            {
                 caRxPacket[1] = cReadChar; // memorizza il secondo carattere
                for(nIndex=2; nIndex<8; nIndex++)
                {
                    caRxPacket[nIndex] = myBLE.getc();
                }
                // dal messaggio estrae e visualizza le coordinate cartesiane
                fX = (((caRxPacket[1]-0x30)*100+(caRxPacket[2]-0x30)*10+(caRxPacket[3]-0x30))-200);
                fY = (((caRxPacket[4]-0x30)*100+(caRxPacket[5]-0x30)*10+(caRxPacket[6]-0x30))-200);
                // converte la posizione del joistick in coordinate polari
                fTeta=atan2(fY,fX)*(180.0/PI); // angolo in gradi nel terzo e quarto quadrante diventa negativo
                if(fTeta < 0) fTeta = fTeta+360.0; // angolo tra 0 e 360°
                fRo=sqrt(pow(fX,2)+pow(fY,2)); //*(10000.0/(sqrt(2)); // modulo del vettore polare. Valore Max =100
                
                
             }
        }
    }
    
}

/**********************************************/
//          IRQ per la Tx su BLE 
//**********************************************/
void pcRxInterrupt(void)
{
    // array per la ricezione dei messaggi da seriale
    char cReadChar; 
    
    // ricevi caratteri su seriale, se disponibili   
    while((pc.readable()))
    {
        // acquisice stringa in input e relativa dimensione
        cReadChar = pc.getc(); // read character from PC
        //myBLE.putc(cReadChar); // write char to BLE
        
        //pc.printf("W>: 0x%02x\n\r",cReadChar);
        if(cReadChar == '0') // se scrivo '0', invia questa stringa
        {
            
        }
    }
}


/**********/
/*  MAIN  */
/**********/
int main()
{
   
    // messaggio di benvenuto
    pc.printf("\r\n*******  Hallo - Exercise ********** \r\n");
    pc.printf("\r\n*** L476 BLE MegaPi Motor Driver  ***\r\n");
    
    //Inizializza pin di output per Rotating Blades
    /*
    OutBlades.mode(OpenDrain);     
    OutBlades.output();
    OutBlades.write(0);
    nMoveBladesCommand = 0; // il comando di movimento Blades inizialmente '0' = spente
    */
    // inizializza variabili
    cCommandBLE = 0; // inizialmente nessun comando da BLE
    cOldCommandBLE = 0; // inizialmente nessun comando da BLE
    fX = 0; // joistick inizialmente nell'origine (X , Y) = (0 , 0)
    fOldX = 0; // joistick inizialmente nell'origine (X , Y) = (0 , 0)
    fY = 0; // joistick inizialmente nell'origine (X , Y) = (0 , 0)
    fOldY = 0; // joistick inizialmente nell'origine (X , Y) = (0 , 0)
        
    // inizializza il BLE
    BleRst = 0;
    wait_ms(100);
    BleRst = 1;
    cCommandBLE = '0';
    cOldCommandBLE = '0';
    
    // inizializza i PWM di pilotaggio dei  motori Posteriore e Anteriore
    PostOutPWB.period_us(10); // periodo del PWM Posteriore
    PostOutPWB.write(0.0); // DutyCycle del PWM Destro (Posteriore)
    AntOutPWB.period_us(10); // periodo del PWM Anteriore
    AntOutPWB.write(0.0); // DutyCycle del PWM Sinistro (Anteriore)
           
          
    // Attiva la IRQ per la RX su seriale   
    myBLE.attach(&BLERxInterrupt,Serial::RxIrq); // // entra in questa routine quando riceve un carattere dalla seriale del BLE
    pc.attach(&pcRxInterrupt,Serial::RxIrq); // entra in questa routine quando riceve un carattere dalla USB del PC
    
    
    
    
    //++++++++++++++++++++++++++++++++++++++++++++++++++++
    //++++++++++++++ INIZIO Ciclo Principale +++++++++++++    
    //++++++++++++++++++++++++++++++++++++++++++++++++++++
    
    while(true)
    {
        
        
        // se ci sono stati cambiamenti nella posizione del joistick, cambia i comandi di velocità delle ruote
        if( (fX != fOldX) || (fY != fOldY))
        {
            fOldX = fX;
            fOldY = fY;
            // algoritmo di conversione dalla posizione del joistick (fX, fY) alla velocità delle ruote (fR, fL)
            fV = (100.0 - fabs(fX)) * (fY/100.0) + fY; // calcolo intermedio
            fW = (100.0 - fabs(fY)) * (fX/100.0) + fX; // calcolo intermedio
            fR = (fV+fW)/2.0; // velocità della ruota destra (-100; +100)
            fL = (fV-fW)/2.0; // velocità della ruota sinistra (-100; +100)
         
            
            // algoritmo di movimentazione delle ruote.
            if(fR < 0) //Ruota destra motorizzata coincide con quella posteriore
            {
                fR =-fR;
                
                // Vai indietro
                PostOutBI1 = 1;
                PostOutBI2 = 0; 
            }
            else
            {
                // Vai avanti
                PostOutBI1 = 0;
                PostOutBI2 = 1; 
            }
            PostOutPWB.write(float(fR/100.0)); // DutyCycle del PWM Destro (Posteriore)
            //Ruota sinistra motorizzata coincide con quella Anteriore
            if(fL < 0) //Ruota destra motorizzata coincide con quella posteriore
            {
                fL =-fL;
                
                // Vai indietro
                AntOutBI1 = 1;
                AntOutBI2 = 0; 
            }
            else
            {
                // Vai avanti
                AntOutBI1 = 0;
                AntOutBI2 = 1; 
            }
            AntOutPWB.write(float(fL/100.0)); // DutyCycle del PWM Sinistro (Anteriore)
        }
        
    } //while (true) Ciclo principale
    
    //++++++++++++++++++++++++++++++++++++++++++++++++++
    //++++++++++++++ FINE Ciclo Principale +++++++++++++    
    //++++++++++++++++++++++++++++++++++++++++++++++++++

} // main()
