// testato su L476RG

#include "mbed.h"
#include<stdlib.h>


// Definizione periferica USB seriale del PC
Serial pc(USBTX, USBRX, 921600); // seriale di comunicazione con il PC. Associati a PA_11 e PA_12

// Definizione periferica seriale del Modulo BLE ELETT114A
Serial myBLE(PA_9, PA_10, 115200); //Tx, Rx, bps

// Input di Reset per il Modulo BLE ELETT114A.
DigitalOut BleRst(PA_8);

// User Button, LED  
DigitalIn myButton(USER_BUTTON); // pulsante Blu sulla scheda. Associato a PC_13
DigitalOut myLed(LED2); // LED verde sulla scheda. Associato a PA_5


//carattere di comando ricevuto dal BLE
volatile char cCommandBLE; // cambia nella routine di interrupt
// memorizza l'ultimo comando ricevuto. Ci saranno delle azioni solo se il comando ricevuto è cambiato rispetto al precedente
char cOldCommandBLE;



//**********************************************/
//          IRQ per la Rx su BLE 
//**********************************************/
void BLERxInterrupt(void)
{
    // array per la ricezione dei messaggi da seriale
    char cReadChar;
    
    // array per la ricezione dei messaggi da seriale
    char caRxPacket[8];
    //int nRxPacketSize;
    
    pc.printf("BLE RxInterrupt: \n\r");
    
    // ricevi caratteri su seriale, se disponibili   
    while((myBLE.readable()))
    {
        // acquisice stringa in input e relativa dimensione
        cReadChar = myBLE.getc(); // Read character
        if(cReadChar == 0x02)
        {
            caRxPacket[0] = cReadChar; // legge e memorizza il primo carattere STX
            cReadChar = myBLE.getc(); // legge il secondo carattere
            if(cReadChar > 0x40)
            {
                // Button:
                caRxPacket[1] = cReadChar;
                caRxPacket[2] = myBLE.getc();
                cCommandBLE = caRxPacket[1];
            }    
            else
            {
            }
        }
    }
}

/**********/
/*  MAIN  */
/**********/
int main()
{
   
    // messaggio di benvenuto
    pc.printf("\r\n*******  Hallo - Exercise 24  ********\r\n");
    pc.printf("\r\n*******    L476 BLE  Driver   ********\r\n");
    
    // inizializza variabili
    cCommandBLE = 0; // inizialmente nessun comando da BLE
    cOldCommandBLE = 0; // inizialmente nessun comando da BLE
        
    // inizializza il BLE
    BleRst = 0;
    wait_ms(100);
    BleRst = 1;
    cCommandBLE = '0';
    cOldCommandBLE = '0';
      
          
    // Attiva la IRQ per la RX su seriale   
    myBLE.attach(&BLERxInterrupt,Serial::RxIrq); // // entra in questa routine quando riceve un carattere dalla seriale del BLE
    //pc.attach(&pcRxInterrupt,Serial::RxIrq); // entra in questa routine quando riceve un carattere dalla USB del PC
    
    //++++++++++++++++++++++++++++++++++++++++++++++++++++
    //++++++++++++++ INIZIO Ciclo test +++++++++++++++++++    
    //++++++++++++++++++++++++++++++++++++++++++++++++++++
    /*
    while(true)
    {
    }
    */
    //++++++++++++++++++++++++++++++++++++++++++++++++++++
    //++++++++++++++ FINE Ciclo test +++++++++++++++++++    
    //++++++++++++++++++++++++++++++++++++++++++++++++++++
    
    
    //++++++++++++++++++++++++++++++++++++++++++++++++++++
    //++++++++++++++ INIZIO Ciclo Principale +++++++++++++    
    //++++++++++++++++++++++++++++++++++++++++++++++++++++
    while(true)
    {
        //Parsing del comando ricevuto, solo se è cambiato il comando.
        if(cCommandBLE != cOldCommandBLE)
        {
            // ricorda il vecchio comando
            cOldCommandBLE = cCommandBLE;
            switch (cOldCommandBLE) // usa cOldCommandBLE. 
            {
                case 'A':
                {
                    // ricevuto il comando 'B1-Pressed'    
                }break;
                case 'B':
                {
                    // ricevuto il comando 'B1-Released'    
                } break;
                case 'C':
                {
                    // ricevuto il comando 'B2-Pressed'    
                } break;
                case 'D':
                {
                    // ricevuto il comando 'B2-Released'    
                } break;
                case 'E': 
                {
                    // ricevuto il comando 'B3-Pressed'    
                } break;
                case 'F': 
                {
                    // ricevuto il comando 'B3-Released'    
                } break;
                case 'G': 
                {
                    // ricevuto il comando 'B4-Pressed'    
                } break;
                case 'H': 
                {
                    // ricevuto il comando 'B4-Released'    
                } break;
                case 'I': 
                {
                    // ricevuto il comando 'B5-Pressed'    
                } break;
                case 'J': 
                {
                    // ricevuto il comando 'B5-Released'    
                } break;
                case 'K': 
                {
                    // ricevuto il comando 'B6-Pressed'    
                } break;
                case 'L': 
                {
                    // ricevuto il comando 'B6-Released'    
                } break;
                default: 
                {
                    // ricevuto comando sconosciuto
                } break;
            }
        }
    } // while(true) 
    //++++++++++++++++++++++++++++++++++++++++++++++++++
    //++++++++++++++ FINE Ciclo Principale +++++++++++++    
    //++++++++++++++++++++++++++++++++++++++++++++++++++

} // main()
