
/* mbed specific header files. */
#include "mbed.h"

// TimeOut in [microsec] per verificare la presenza del sensore prossimità. Se il sensore non è presente il timer supera TIMEOUTPROXSENSOR
#define TIMEOUTPROXSENSOR 16000 //tempo in [microsec]

// seriale, pulsante Blu e LED verde su scheda
Serial pc(USBTX, USBRX);
DigitalOut myLed (LED2);
DigitalIn myButton(USER_BUTTON);


//AnalogOut OutRed(PA_0);
//AnalogOut OutBlue(PA_1);
//AnalogOut OutGreen(PA_4);

DigitalOut OutRed(PA_0);
DigitalOut OutBlue(PA_1);
DigitalOut OutGreen(PA_4);

// Pin su cui è collegato il sensore di prossimità
DigitalInOut InOutProxSensor (PC_0, PIN_OUTPUT, PullDown, 0); // Pin di tipo In-Out per la gestione del segnale Sig del Sensore di prossimità a ultrasuoni

// Indici per i cicli
int nIndex, nIndexBlue, nIndexRed, nIndexGreen;

// Timer per il calcolo dei tempi del sensore di prossimità
Timer TimerProxSensor;

// distanza in cm dell'ostacolo
double fDistance;

// tempo inizio intermedio e fine del timer che misura la distanza con il sensore ultrasuoni
int nTimerStart, nTimerCurrent, nTimerStop, nTimerTillNow;





/********/
/* Main */
/********/
int main()
{
    // configura velocità della comunicazione seriale su USB-VirtualCom e invia messaggio di benvenuto
    pc.baud(921600); //921600 bps
    
    // Inizializza LED con sequenza
    OutRed=0;
    OutBlue=0;
    OutGreen=0;
    //OutGreen.write_u16(0);
    
    wait_ms(500);
    OutRed = 1;
    wait_ms(500);
    OutGreen = 1;
    wait_ms(500);
    OutBlue = 1;
    wait_ms(500);
    
    
    OutRed = 0;
    wait_ms(300);
    OutGreen = 0;
    wait_ms(300);
    OutBlue = 0;
    wait_ms(500);
    
    myLed=0;
    
    
    while(true)
    {
        //++++++++++++++ INIZIO Acquisisci distanza ostacoli +++++++++
        //inizializza misura di distanza
        fDistance=0.0;
        // Fissa come Output il pin InOutProxSensor
        InOutProxSensor.output();
        // Poni 'L' sul Pin e mantienilo per qualche microsecondo
        InOutProxSensor.write(0);
        wait_us(5);
        // Poni 'H' sul Pin e mantienilo per qualche microsecondo
        InOutProxSensor.write(1);
        wait_us(10);
        // Poni 'L' sul Pin e mantienilo per qualche microsecondo
        InOutProxSensor.write(0);
        // Attendi assestamento e Fissa come Input il pin InOutProxSensor
        wait_us(5);
        InOutProxSensor.input();
        InOutProxSensor.mode(PullDown); // se non è presente il sensore, il pin rimane a '0'
        
        // attende la risposta del sensore di prossimità per un tempo fissato da TIMEOUTPROXSENSOR. Dopo tale tempo dichiara inesistente il sensore
        TimerProxSensor.start();
        nTimerStart = TimerProxSensor.read_us();
        nTimerTillNow=(TimerProxSensor.read_us()-nTimerStart);
        while((InOutProxSensor ==0) && (nTimerTillNow< TIMEOUTPROXSENSOR))
        {
            nTimerCurrent = TimerProxSensor.read_us();
            nTimerTillNow=nTimerCurrent-nTimerStart;
            //myLed=1; // se rimane nel while il LED rimane acceso
            //pc.printf("sono qui 2 \r\n"); //scopi diagnostici
        }
        TimerProxSensor.stop(); // spegne il timer che serve per misurare il timeout quando assente il sensore di prossimità
        //pc.printf("\r\nUscita dal while, nTimerTillNow = %d\r\n", nTimerTillNow); //scopi diagnostici
        // se nTimerTillNow è inferiore al TIMEOUT, il sensore è presente e quindi misura la distanza dell'ostacolo
        if(nTimerTillNow < TIMEOUTPROXSENSOR)
        {
            // riattiva il timer per misurare la distanza dell'ostacolo
            TimerProxSensor.start();
            nTimerStart = TimerProxSensor.read_us();
            while(InOutProxSensor == 1)
            {
                //myLed=1; // se rimane nel while il LED rimane acceso
            }
            TimerProxSensor.stop();
            nTimerStop = TimerProxSensor.read_us();
           
            //pc.printf("\r\nSensore Presente, nTimerTillNow = %d\r\n", nTimerTillNow); //scopi diagnostici
        
            // velocità del suono = 343 [m/s] = 0.0343 [cm/us] = 1/29.1 [cm/us]
            // tempo di andata e ritorno del segnale [us] = (TimerStop-TimerStart)[us]; per misurare la distanza bisogna dividere per due questo valore
            // distanza dell'ostacolo [cm] = (TimerStop-TimerStart)/2 [us] * 1/29.1[cm/us]
            fDistance = (nTimerStop-nTimerStart)/58.2;
            // invia il dato al PC
            //pc.printf("Distanza dall'ostacolo = %f0.2\r\n", fDistance);
        }    
        else
        {
           // quando esce dai while bloccanti, il LED si spegne
           //myLed=0; // scopi diagnostici
           pc.printf("\r\nTimeOut\r\n"); // scopi diagnostici
        }
        //++++++++++++++ FINE Acquisisci distanza ostacoli +++++++++  
        
        //++++++++++++++ INIZIO pilota accensione delle strip LED +++++++++++++++++++++++++
        //escludi le misure oltre un range massimo e minimo. le distanze sono espress in [cm]
        if((fDistance <= 400.0) && (fDistance >= 3.0)) 
        {
            // se un ostacolo si trova nel range di misura, accendi i LED
            OutRed = 1;
            wait_ms(100);
            OutGreen =1;
            wait_ms(100);
            OutBlue = 1;
            myLed=1; // scopi diagnostici
            pc.printf("Distanza dell'ostacolo = %f0.2\r\n", fDistance); // scopi diagnostici
         }
        else
        {
            OutRed = 0;
            wait_ms(100);
            OutGreen =0;
            wait_ms(100);
            OutBlue = 0;
            myLed=0; // scopi diagnostici
            pc.printf("Distanza dell'ostacolo fuori range = %f0.2\r\n", fDistance); // scopi diagnostici
         
        }
        //++++++++++++++ FINE pilota accensione delle strip LED +++++++++++++++++++++++++
        //wait_ms(100);
    }// while(true)
}
