// Tested: NUCLEO-L476RG
// Tested: NUCLEO-F207ZG
#include "mbed.h"

// genera un oggetto serial collegato al PC
Serial pc(USBTX, USBRX);

// genera un oggetto DigitalOut collegato al Led
DigitalOut MyLed1(LED1); // verde
DigitalOut MyLed2(LED2); // blu
DigitalOut MyLed3(LED3); // rosso


// indice per i cicli
int nIndex;

// carattere ricevuto dal PC
char cReadChar;
// carattere inviato al PC
char cWriteChar;


/********/
/* MAIN */
/********/
int main() 
{
    // configura velocità della comunicazione seriale su USB-VirtualCom e invia messaggio di benvenuto
    pc.baud(921600); //921600 bps
    
    // inizializza variabili
    cReadChar = '\0';
    MyLed1=0; // spegni il Led1
    MyLed2=0; // spegni il Led2
    MyLed3=0; // spegni il Led3
  
    
    pc.printf("\r\n> Hallo Amaldi Students - Start Exercise 1 \r\n");
 
/******* INIZIO ESEMPIO CON POLLING  ***/    
    // ciclo infinito
    while(true)
    {
        // spegne il Led per 0.5 sec
        MyLed1 = 0;
        MyLed2 = 0;
        MyLed3 = 0;
        wait_ms(500);
                
        // verifica se è arrivato un carattere dal PC
        if(pc.readable())
        {
            // cattura il carattere ricevuto 
            cReadChar = pc.getc();
            
            //accendi il Led per 500ms
            // Accende il Led solo se invio carattere corretto 
            if(cReadChar == 'p')
            {
                MyLed1 = 1;
                MyLed2 = 1;
                MyLed3 = 1;
                wait_ms(500);
            }
            
            // restituisci messaggio al PC su carattere ricevuto
            cWriteChar = cReadChar+1; 
            pc.printf("Rx Char= %c; Tx Char = %c\n\r", cReadChar, cWriteChar);
         }
    }

/******* FINE ESEMPIO CON POLLING ***** */

}