// Tested: NUCLEO-F401RE
#include "mbed.h"

// numero di acqusizioni su cui effettuare la media della luminosità e della temperatura
#define NUMSAMPLELIGHT 300
#define NUMSAMPLETEMP 300

// soglie massime e minime per azionamento relè. L'attuatore si spegne se viene superata la soglia massima e si accende se si scende sotto la soglia minima


// seriale per la comunicazione con il PC su USB
Serial pc(USBTX, USBRX);

// Output LED di diagnostica
DigitalOut myLED(LED2); // verde


// sensore di luminosità
AnalogIn InLight (PA_0);

// sensore di temperatura
AnalogIn InTemp (PA_1);

// relay per accendere/spegnere le luci
DigitalOut LightRelay (PB_0);

// relay per accendere/spegnere il termoventilatore
DigitalOut HeaterRelay (PC_1);

// ticker per l'acquisizione dell'onda con ADC
//Ticker SamplingTicker;

// carattere in arrivo dal PC ed equivalente numerico
char cReadChar;
int nReadChar;

// flag che diventa true quando si vuole fermare l'acquisizione
bool bStop;

// valore letto dall'ADC di luminosità e temperatura e corrispondenti valori in tensione
unsigned short usReadLightADC;
float fReadLightVoltage;
unsigned short usReadTempADC;
float fReadTempVoltage;


// valore di luminosità letto dall'ADC
double fLight;

// valore di temperatura letto dall'ADC
double fTemp;

// indice per i cicli di calcolo temperatura e luminosità
int nTempIndex;
int nLightIndex;

// valore medio della Luminosità e della temperatura su NUMACQUISISIONI acquisizioni
double fAvgLight;
double fAvgTemp;
 

 //*******************
 // Loop Principale
 //*******************  
int main()
{
    // periodo di campionamento
    int nDeltaT;
    
    // inizializza variabili
    HeaterRelay = 0; // spegne inizialmente il termoventilatore
    LightRelay = 0; // spegne inizialmente le luci
    
     // configura velocità della comunicazione seriale su USB-VirtualCom e invia messaggio di benvenuto
    pc.baud(921600); //921600 bps
    
    // messaggio di benvenuto
    pc.printf("\r\n  Hallo Amaldi Students - Exercise 18 \r\n");
    pc.printf("\r\n*** Light and Temperature Control ***\r\n");
    
    // test dei LED
    myLED=1; // Verde
    wait_ms(1000);
    myLED=0;
    
    
    
    while(true) 
    {
    
        //++++++++++++++ INIZIA ACQUISIZIONE DELLA LUMINOSITA +++++++++++++++++++++
        // inizializza il valore medio della Luminosità 
        fAvgLight=0.0;
        for(nLightIndex=0; nLightIndex < NUMSAMPLELIGHT; nLightIndex++)
        {
            // acquisisce dato da ADC
            usReadLightADC = InLight.read_u16();
            fReadLightVoltage=(usReadLightADC*3.3)/65535.0; // converte in Volt il valore numerico letto dall'ADC
            //fReadVoltage=InWave.read(); // acquisisce il valore dall'ADC come valore di tensione in volt
            fLight= fReadLightVoltage; //ATTENZIONE Visualizza il valore grezzo letto dall'ADC
            fAvgLight+=fLight;
        }   
        // calcola valore medio su NUMSAMPLE acquisizioni 
        fAvgLight/= NUMSAMPLELIGHT;
        
        // accendi Luce in base a superamento soglie.
        if (fAvgLight <= 0.7) // aumentando la luminosita, si riduce il valore di tensione acquisito da ADC
        {
            LightRelay = 0; // spegni la luce
        }
        else
        {
            if(fAvgLight >= 1)
            {
                LightRelay =1; // accendi la luce
            }
        }
        
        // invia il dato di luminosità al PC
        //pc.printf("\n\r--- Voltage= %.1f [Volt]; Brightness= %.1f [Celsius] ---\n\r", fReadVoltage, fLight);
        pc.printf("\n\r--- Digital= %d [Volt]; Brightness= %.2f [Lux] ---\n\r", usReadLightADC, fLight);
        //+++++++++++++ FINE ACQUISISCE DA SENSORE LUMINOSITA ++++++++++++++++
        
        //+++++++++++++ INIZIO ACQUISISCE DA SENSORE TEMPERATURA ++++++++++++
        // inizializza il valore medio della temperatura 
        fAvgTemp=0.0;
        for(nTempIndex=0; nTempIndex < NUMSAMPLETEMP; nTempIndex++)
        {
            // acquisisce dato da ADC
            usReadTempADC = InTemp.read_u16();
            fReadTempVoltage=(usReadTempADC*3.3)/65535.0; // converte in Volt il valore numerico letto dall'ADC
            //fReadVoltage=InWave.read(); // acquisisce il valore dall'ADC come valore di tensione in volt
            fTemp= ((fReadTempVoltage-0.25)*100.0)/(3.05-0.25); //applica la formula della retta che passa per i punti estremi del range del sensore
            fAvgTemp+=fTemp;
        }   
        // calcola valore medio su NUMSAMPLE acquisizioni 
        fAvgTemp/= NUMSAMPLETEMP;
        
        if(fAvgTemp < 23) // accende il riscaldamento se la temperatura è inferiore a 25°C
        {
            HeaterRelay = 1; // accende il relay del riscaldamento
            myLED=1; // scopi diagnostici
        }
        else
        {
            if(fAvgTemp > 25)
            { 
                HeaterRelay = 0; // spegne il relay del riscaldamento
                myLED=0; // scopi diagnostici
            }
        }
            
        
        // invia il dato al PC
        //pc.printf("\n\r--- Voltage= %.1f [Volt]; Temperature= %.1f [Celsius] ---\n\r", fReadVoltage, fTemp);
        pc.printf("\n\r--- Digital= %d [Volt]; Temperature= %.2f [Celsius] ---\n\r", usReadTempADC, fTemp);
       
        //+++++++++++++ FINE ACQUISISCE DA SENSORE TEMPERATURA ++++++++++++++  
     
    } // while(true)
}














