#include "mbed.h"
#include "stdlib.h"
#include <Timer.h>

// genera un oggetto serial collegato al PC
Serial pc(USBTX, USBRX);
DigitalOut myLed(LED1);

// moltiplicatore del tempo in millisecondi
double nMultiplier = 500.0;  
Timer myTimer;

// Tempo a disposizione del giocatore per colpire il piezo dopo l'accensiond del LED
int32_t nDelay = 500; // tempo in [msec]
float fDelay = 500.0; // tempo in [msec]

// tempi  misurati con il timer
int32_t nStartTimeGame, nElapsedTimeGame, nCurrentTimeGame;

// seme per la generazione di numeri casuali
unsigned int nSeed;

// pulsante su cui bisogna colpire
DigitalIn InPiezo(PA_4);



/********/
/* MAIN */
/********/
int main() 
{
    // velocità di comunicazione sulla seriale con PC
    pc.baud(921600);
    
    // inizialmente spegne LED
    myLed=0;
    
    // pc.printf("RANDMAX= %d\r\n", RAND_MAX); // scopi diagnostici
        
    while(1) 
    {
        // avvia il timer
        myTimer.start();
        //rand() fissa sempre la stessa sequenza di numeri patendo da 1, 
        //srand(seed) fissa il numero di partenza, seed, ma la sequenza è sempre la stessa
        // per generare una sequenza diversa partendo da un numero diverso il seed lo imposto leggendo l'orologio di sistema (p.e. timer)
        // RAND_MAX = 2147483647
        nSeed = unsigned(myTimer.read_ms()% RAND_MAX); // resto della divisione timer_read_ms() / RAND_MAX
        srand(nSeed);
        
        
        // calcola il tempo entro il quale è attesa la risposta del giocatore
        fDelay = (nMultiplier * (float(rand()) / RAND_MAX));
        // pc.printf("\r\ndelay float = %f\r\n", fDelay); // scopi diagnostici
        nDelay = int(fDelay);
        //pc.printf("delay int = %d\r\n", nDelay); // scopi diagnostici
        
        // se il ritardo è maggiore di 5000, dividilo per 3 fino a quando non diventa inferiore a 5000
        while(nDelay > 5000)
        {
            nDelay /= 3;
        }
        
        // se il ritardo è minore di 100, moltiplicalo per 2 fino a quando non diventa maggiore di 100    
        while(nDelay < 100)
        {
            nDelay *= 2;    
        }
        
        // accendi il LED e attendi che il giocatore prema sul piezo
        nStartTimeGame = myTimer.read_ms(); // istante di partenza del gioco
        myLed = 1;
        while( (InPiezo == 0) && (nElapsedTimeGame < nDelay) )
        {
            nCurrentTimeGame = myTimer.read_ms(); // acquisisci il timer attuale
            nElapsedTimeGame = (nCurrentTimeGame - nStartTimeGame); // tempo trascorso dall'inizio gioco 
        }
        myLed = 0;
        myTimer.stop(); // istante di fine del gioco
        
        
        // stampa la risposta e il tempo a disposizione
        pc.printf("\r\nrisposta in = %d; tempo a disposizione= %d \r\n", nElapsedTimeGame, nDelay);
        if(nElapsedTimeGame < nDelay)
        {
            pc.printf("GOOD !!! \r\n"); // il giocatore ha risposto prima della scadenza del timer
        }
        else
        {
             pc.printf("BAD ... \r\n"); // il giocatore ha risposto dopo la scadenza del timer
        }
       
        
        
        
    }            
}