
/* mbed specific header files. */
#include "mbed.h"

// seriale, pulsante Blu e LED verde su scheda
Serial pc(USBTX, USBRX);
DigitalOut Led2 (LED2);
DigitalIn myButton(USER_BUTTON);

DigitalOut OutA (PB_0);
DigitalOut OutB (PC_1);

DigitalOut myLed(PC_9);




/********/
/* Main */
/********/
int main()
{
    // configura velocità della comunicazione seriale su USB-VirtualCom e invia messaggio di benvenuto
    pc.baud(921600); //921600 bps
     
    pc.printf("Test Motore\r\n");
    
    while(true)
    {
        // spegni LED esterno
        myLed=0;
        
        //Ferma motore
        OutA=0;
        OutB=0;
        pc.printf("OutA OutB = 00\r\n");
        wait_ms(2000);
        
        
        // Ruota Left
        OutA=0;
        OutB=1;
        pc.printf("OutA OutB = 01\r\n");
        wait_ms(2000);
        
        // spegni LED interno
        myLed=1;
        
        //Ferma motore
        OutA=0;
        OutB=0;
        pc.printf("OutA OutB = 00\r\n");
        wait_ms(2000);
        
        //Ferma motore
        OutA=1;
        OutB=0;
        pc.printf("OutA OutB = 10\r\n");
        wait_ms(2000);
        
        // Ruota Right
        OutA=1;
        OutB=1;
        pc.printf("OutA OutB = 11\r\n");
        wait_ms(2000);
        
        OutA=1;
        OutB=0;
        pc.printf("OutA OutB = 10\r\n");
        wait_ms(2000);
        
        
        
    }
 }

/************************ (C) COPYRIGHT STMicroelectronics *****END OF FILE****/
