// Tested : NUCLEO F207ZG, L476
//#include "SampledSoundTrattore.h"
//#include "SampledSoundGurgle.h"
//#include "Calcson.h"
#include "SampledSound.h"//vito
#include "mbed.h"
#include "Clacson.h" //vito
#include "mbed.h"
#include <stdlib.h>
#include "L6208.h"

// Definizione periferiche
DigitalIn Input (PC_0);
AnalogIn InWave(PA_0);
Serial pc(USBTX, USBRX);
DigitalOut LedAD (PC_2) ;
DigitalOut LedAS (PC_3) ;
DigitalOut LedPD (PC_10) ;
DigitalOut LedPS (PC_12) ;
AnalogOut OutWave(PA_4); // pin di output per la forma d'onda analogica
DigitalOut myD2(PA_10);//pin di output proveniente dal raspberry
DigitalIn myButton(USER_BUTTON); // User Button
DigitalOut led2(LED2); // LED su scheda

#ifdef TARGET_NUCLEO_F334R8
#define VREFA_PWM_PIN D11
#define VREFB_PWM_PIN D9
#elif TARGET_NUCLEO_F302R8
#define VREFA_PWM_PIN D11
#define VREFB_PWM_PIN D15 /* HW mandatory patch: bridge manually D9 with D15 */
#else
#define VREFA_PWM_PIN D3
#define VREFB_PWM_PIN D9
#endif



// ticker per la generazione dell'onda con DAC
Ticker SampleOutTicker;

void my_error_handler(uint16_t error)
{
  /* Printing to the console. */
  pc.printf("Error %d detected\r\n\n", error);
  
  /* Infinite loop */
  while (true) {
  }    
}



// ticker per l'acquisizione dell'onda con ADC
Ticker SamplingTicker;

// carattere in arrivo dal PC ed equivalente numerico
volatile char cReadChar;
volatile int nReadChar;

// flag che diventa true quando si vuole fermare l'acquisizione
volatile bool bStop;

// valore letto dall'ADC e corrispondente in tensione
volatile unsigned short usReadADCLux;
volatile float fReadVoltage;

// valore di temperatura letto dall'ADC
volatile float fLux;                                                                                                                                                                                                       

// prototipo di funzione che genera i campioni della sinusoide da utilizzare per la generazione tramite DAC
void CalculateSinewave(void);
// funzione di generazione suono della frequenza e ampiezza selezionate
void SoundGenerate(double fFrequency);
                
// carattere in arrivo dal PC

volatile char CReadMusic;                

uint32_t nProva;

// indice nell'array dei campioni da porre in output da DAC per Marimba
volatile uint32_t nSampleSoundIndex;

// Periodo di generazione campioni in output DeltaT = T/NumSample
double fDeltaT;
// amplificazione per il dato da spedire sull'ADC
volatile double fAmp;
//volatile double fAmpNew;
// flag per bloccare la generazione del segnale
volatile int bGenerate = false;

// frequenza segnale da generare
volatile double fFreq;
//flag che diventa true se bisogna fermare la generazione di suoni

// periodo della sinusoide da generare
double fPeriod;
// tipo di suono da generare: 0=Sine, 1= Square
char cSoundWave;

// nota corrispondente al tasto premuto
volatile char cKeyToPlay= '\0';


//**********************************************************************
// generazione suoni con i sample da file di campioni in SoundSample.h 
//**********************************************************************
void SampleOut() 
{
   
    // genera campioni fino al raggiungimento del numero di campioni nel file Sound.h
    if((nSampleSoundIndex < nSampleNum) && (bGenerate == true))
    {
        // mette in output un campione della forma d'onda moltiplicato per l'amplificazione fAmp
        OutWave.write_u16(naInputSoundWave[nSampleSoundIndex]*fAmp);
        // incrementa l'indice del campione in output, nSampleNum è il numero dei campioni nle file Sound.h
        nSampleSoundIndex++;
    }
    else
    {
        // se è stato generato il numero di campioni del file oppure bGenerate = false, ferma la generazione di suoni
        bGenerate = false;
    }    
}

// prototipo di funzione che genera i campioni della sinusoide da utilizzare per la generazione tramite DAC
void CalculateSinewave(void);
// funzione di generazione suono della frequenza e ampiezza selezionate
void SoundGenerate(double fFrequency);
                
//**********************************************************************
// generazione suoni con i sample da file di campioni in SoundSample.h 
//**********************************************************************

//*******************
// Loop Principale
//*******************  
int main()
{
    
    // configura velocità della comunicazione seriale su USB-VirtualCom e invia messaggio di benvenuto
  pc.baud(921600); //921600 bps
  //pc.baud(9600); //256000 bps
  pc.printf("*** Test Motor ***\n\r");
  
  /* Printing to the console. */
  pc.printf("STARTING MAIN PROGRAM\r\n");
  pc.printf("    Reminder:\r\n");
  pc.printf("    The position unit is in agreement to the step mode.\r\n");
  pc.printf("    The speed, acceleration or deceleration unit depend on the step mode:\r\n");
  pc.printf("    - For normal mode and half step mode, the unit is steps/s or /s^2.\r\n");
  pc.printf("    - For microstep modes, the unit is (1/16)steps/s or /s^2.\r\n");
    
//----- Initialization 
  /* Initializing Motor Control Component. */
  motor = new L6208(D2, D8, D7, D4, D5, D6, VREFA_PWM_PIN, VREFB_PWM_PIN);
  if (motor->init(&init) != COMPONENT_OK) {
    exit(EXIT_FAILURE);
  }

  /* Attaching and enabling an interrupt handler. */
  motor->attach_flag_irq(&my_flag_irq_handler);
  motor->enable_flag_irq();
    
  /* Attaching an error handler */
  motor->attach_error_handler(&my_error_handler);

  /* Printing to the console. */
  pc.printf("Motor Control Application Example for 1 Motor\r\n");

//----- run the motor BACKWARD
  pc.printf("--> Running the motor backward.\r\n");
  motor->run(StepperMotor::BWD);
  
  while (motor->get_status()!=STEADY) {
    /* Print reached speed to the console in step/s or microsteps/s */
    pc.printf("    Reached Speed: %d microstep/s.\r\n", motor->get_speed());
    wait_ms(50);    
  }
  pc.printf("    Reached Speed: %d microstep/s.\r\n", motor->get_speed());
     
  /* Wait for 1 second */  
  wait_ms(1000);
  

  
//----- Soft stop required while running
  pc.printf("--> Soft stop requested.\r\n");
  motor->soft_stop(); 
  
  
//----- Change step mode to full step mode
  motor->set_step_mode(StepperMotor::STEP_MODE_FULL);
  pc.printf("    Motor step mode: %d (0:FS, 1:1/2, 2:1/4, 3:1/8, 4:1/16).\r\n", motor->get_step_mode());
  
  /* Get current position of device and print to the console */
  pc.printf("    Position: %d.\r\n", motor->get_position());
  
  /* Set speed, acceleration and deceleration to scale with normal mode */
  motor->set_max_speed(init.maxSpeedSps>>4);
  motor->set_acceleration(motor->get_acceleration()>>4);
  motor->set_deceleration(motor->get_deceleration()>>4);
  /* Print parameters to the console */  
  pc.printf("    Motor Max Speed: %d step/s.\r\n", motor->get_max_speed());
  pc.printf("    Motor Min Speed: %d step/s.\r\n", motor->get_min_speed());
  pc.printf("    Motor Acceleration: %d step/s.\r\n", motor->get_acceleration());
  pc.printf("    Motor Deceleration: %d step/s.\r\n", motor->get_deceleration());
  
//----- move of 200 steps in the FW direction
  pc.printf("--> Moving forward 200 steps.\r\n");
  motor->move(StepperMotor::FWD, 200);
int i,a=0;
  
  while (true) {
  
  if ( Input == 0 ) 
  {
     a=a+1;
   }
   if(a>1)
   {
    a=0;
     
   }
         
     if(a==0)
     {
        /* Request device to go position -3200 */
        motor->go_to(150);
        /* Waiting while the motor is active. */
       motor->wait_while_active();
    }
    else 
    {
        /* Request device to go position -3200 */
     motor->go_to(-150);
     /* Waiting while the motor is active. */
     motor->wait_while_active();
    
    // periodo di campionamento
    int nDeltaT;
    
        
    // configura velocità della comunicazione seriale su USB-VirtualCom e invia messaggio di benvenuto
    pc.baud(921600); //921600 bps
    // messaggio di benvenuto
    pc.printf("\r\nHey Bro! Say Goodbye to your Sister !\r\n");
    pc.printf("Enter Acquisition Time, DeltaT[sec]= [1 - 9]: \r\n");
   // pc.printf("\r\n*** Bluetooth Temp Acquisition ***\r\n");
    
    // inizializza variabili
    bStop=true;
    //myRele = 0x00; // spegni il relè
    
    
     
    LedAD =0x00 ;
    LedAS =0x00 ;
    LedPD =0x00 ;
    LedPS =0x00 ;
    wait(1);
    LedAD =0x01 ;
    LedAS =0x01 ;
    LedPD =0x01 ;
    LedPS =0x01 ;
    wait(1);
    LedAD =0x00 ;
    LedAS =0x00 ;
    LedPD =0x00 ;
    LedPS =0x00 ;
    wait(1);
    LedAD =0x01;
    wait_ms(500);
    LedAS =0x01 ;
    wait_ms(500);
    LedPD =0x01 ;
    wait_ms(500);
    LedPS =0x01 ;
    wait(1);   
    
    //inizializza variabili gggggggggggggggggggggggggggggggggggggggggggggggggggggggggg
    bGenerate= false;
   bStop= true;
    cReadChar= 0;
    //nSampleOutIndex= 0;
    //nSampleOutCount= 0;
    nSampleSoundIndex= 0;
    
     //imposta il funzionamento del pulsante come "PullDown": Aperto = '0'. L'altra modalità di funzionamento è PullUp
    myButton.mode(PullUp);
    
    // configura velocità della comunicazione seriale su USB-VirtualCom e invia messaggio di benvenuto
    pc.baud(921600); //921600 bps
    
    // test dei LED
    led2=1; // Blu
    wait_ms(500);
    led2=0;
        
   pc.printf("\r\nHallo Amaldi Students - Exercise 12 \r\n");
    pc.printf("\n\r*** Sampled Sound Generator ***\n\r");
                
    // fissa l'amplificazione da 0 a 1
    fAmp = 1.0;  
      
    // attende la pressione di tasti sulla marimba
    while(true)
    {   
        if(myButton == 0)
        {
            while(myButton != 1){}; // attendi che il tasto sia rilasciato
            fFreq=nSamplePerSec/nUnderSampleFactor;// campioni per secondo da generare = nSamplePerSec/nUnderSampleFactor
            pc.printf("--- Sound Generation ---\n\r");
            pc.printf("--- Clacson ---\n\r");
            if (myD2 == 1)
            {
             bGenerate = true; // flag true quando è attiva la generazione di suoni
             nSampleSoundIndex =0; //inizializza indice dell'array
             fDeltaT = (1.0/fFreq);  // fFreq dipende dal periodo di campionamento e dal fattore di sottocampionamento
             SampleOutTicker.attach(&SampleOut,fDeltaT); // avvia generazione
            }
            else
            {
             bGenerate = false; // arresta la generazione di suoni
            }
        }
    } // while   
   
}