// Tested : NUCLEO F207ZG, L476
#include "SampledSound.h"
#include "mbed.h"
#include<stdlib.h>


// Definizione periferiche
Serial pc(USBTX, USBRX);
AnalogOut OutWave(PA_4); // pin di output per la forma d'onda analogica
DigitalIn myButton(USER_BUTTON); // User Button
DigitalOut led2(LED2); // LED su scheda

// ticker per la generazione dell'onda con DAC
Ticker SampleOutTicker;



// prototipo di funzione che genera i campioni della sinusoide da utilizzare per la generazione tramite DAC
void CalculateSinewave(void);
// funzione di generazione suono della frequenza e ampiezza selezionate
void SoundGenerate(double fFrequency);
                
// carattere in arrivo dal PC
volatile char cReadChar;
volatile char CReadMusic; 


// indice nell'array dei campioni da porre in output da DAC per Marimba
volatile int nSampleSoundIndex;

// Periodo di generazione campioni in output DeltaT = T/NumSample
double fDeltaT;
// amplificazione per il dato da spedire sull'ADC
volatile double fAmp;
//volatile double fAmpNew;
// flag per bloccare la generazione del segnale
volatile int bGenerate = false;

// frequenza segnale da generare
volatile double fFreq;
//flag che diventa true se bisogna fermare la generazione di suoni
volatile int bStop=true;
// periodo della sinusoide da generare
double fPeriod;
// tipo di suono da generare: 0=Sine, 1= Square
char cSoundWave;

// nota corrispondente al tasto premuto
volatile char cKeyToPlay= '\0';

//**********************************************************************
// generazione suoni con i sample da file di campioni in SoundSample.h 
//**********************************************************************
void SampleOut() 
{
   
    // genera campioni fino al raggiungimento del numero di campioni nel file Sound.h
    if((nSampleSoundIndex < nSampleNum) && (bGenerate == true))
    {
        // mette in output un campione della forma d'onda moltiplicato per l'amplificazione fAmp
        OutWave.write_u16(naInputSoundWave[nSampleSoundIndex]*fAmp);
        // incrementa l'indice del campione in output, nSampleNum è il numero dei campioni nle file Sound.h
        nSampleSoundIndex++;
    }
    else
    {
        // se è stato generato il numero di campioni del file oppure bGenerate = false, ferma la generazione di suoni
        bGenerate = false;
    }    
}

//*******************
// Loop Principale
//*******************  
int main()
{
    //inizializza variabili
    bGenerate= false;
   bStop= true;
    cReadChar= 0;
    //nSampleOutIndex= 0;
    //nSampleOutCount= 0;
    nSampleSoundIndex= 0;
    
     //imposta il funzionamento del pulsante come "PullDown": Aperto = '0'. L'altra modalità di funzionamento è PullUp
    myButton.mode(PullUp);
    
    // configura velocità della comunicazione seriale su USB-VirtualCom e invia messaggio di benvenuto
    pc.baud(921600); //921600 bps
    
    // test dei LED
    led2=1; // Blu
    wait_ms(500);
    led2=0;
        
   pc.printf("\r\nHallo Amaldi Students - Exercise 12 \r\n");
    pc.printf("\n\r*** Sampled Sound Generator ***\n\r");
                
    // fissa l'amplificazione da 0 a 1
    fAmp = 1.0;  
      
    // attende la pressione di tasti sulla marimba
    while(true)
    {   
        if(myButton == 0)
        {
            while(myButton != 1){}; // attendi che il tasto sia rilasciato
            fFreq=nSamplePerSec;// campioni per secondo da generare
            pc.printf("--- Generazione B1 ---\n\r");
            bGenerate = true; // flag true quando è attiva la generazione di suoni
            nSampleSoundIndex =0; //inizializza indice dell'array
            fDeltaT = (1.0/fFreq);  // fFreq dipende dal periodo di campionamento
            SampleOutTicker.attach(&SampleOut,fDeltaT); // avvia generazione
        }
    } // while   
}