#include "Lwm2m_Server_Object.h"
#include "Lwm2m_RW_Resource.h"
#include "Lwm2m_E_Resource.h"

using namespace std;

void update_trigger(Lwm2m_Node * node){
    
    node->get_Register_Interface()->Update();
    
}


//Resource constructor : Lwm2m_RW_Resource<TYPE>(ID,NAME,MULTIPLE,MANDATORY,OBJECT,INITIAL_VALUE,READ?,READ_FUNC (NULL FOR DEFAULT),WRITE?,WRITE_FUNC(NULL FOR DEFAULT))
//                       Lwm2m_E_Resource(int Id, std::string name, bool multiple_instance, bool mandatory,OBJECT, void (*exec_func)(), Lwm2m_Node *node);

Lwm2m_Server_Object::Lwm2m_Server_Object(uint16_t object_Id, int object_Instance, bool multiple_instance, bool mandatory, std::string object_URN,Lwm2m_Node * node) : Lwm2m_Object( object_Id, object_Instance,multiple_instance,mandatory,object_URN,node){
    
    _resources->insert(make_pair(LWM2M_SERVER_SHORT_ID_ID, new Lwm2m_RW_Resource<int>(LWM2M_SERVER_SHORT_ID_ID,"Short Server Id",false,true,this,1,true,NULL,false,NULL)));
    _resources->insert(pair<int, Lwm2m_RW_Resource<int>*>(LWM2M_SERVER_LIFETIME_ID, new Lwm2m_RW_Resource<int>(LWM2M_SERVER_LIFETIME_ID,"Lifetime",false,true,this,60*5,true,NULL,true,NULL)));
    _resources->insert(pair<int, Lwm2m_RW_Resource<int>*>(LWM2M_SERVER_MIN_PERIOD_ID, new Lwm2m_RW_Resource<int>(LWM2M_SERVER_MIN_PERIOD_ID,"Default Minimum Period",false,false,this,1,true,NULL,true,NULL)));
    _resources->insert(pair<int, Lwm2m_RW_Resource<int>*>(LWM2M_SERVER_MAX_PERIOD_ID, new Lwm2m_RW_Resource<int>(LWM2M_SERVER_MAX_PERIOD_ID,"Default Maximum Period",false,false,this,90,true,NULL,true,NULL)));
    
    _resources->insert(pair<int, Lwm2m_RW_Resource<bool>*>(LWM2M_SERVER_STORING_ID, new Lwm2m_RW_Resource<bool>(LWM2M_SERVER_STORING_ID,"Notification Storing when Disabled or Offline",false,true,this,true,true,NULL,true,NULL)));
    
    _resources->insert(pair<int, Lwm2m_RW_Resource<string>*>(LWM2M_SERVER_BINDING_ID, new Lwm2m_RW_Resource<string>(LWM2M_SERVER_BINDING_ID,"Binding",false,true,this,"U",true,NULL,true,NULL)));
    
    void (*ptr1)(Lwm2m_Node*);
    ptr1=update_trigger;
    
    _resources->insert(pair<int, Lwm2m_E_Resource*>(LWM2M_SERVER_UPDATE_ID, new Lwm2m_E_Resource(LWM2M_SERVER_UPDATE_ID,"Update Trigger",false,true,this,ptr1,_node)));
    
    //_resources->insert(pair<int, Lwm2m_E_Resource*>(LWM2M_SERVER_UPDATE_ID, new Update_Trigger(LWM2M_SERVER_UPDATE_ID,"Update Trigger",false,true,this,ptr1,_node)));
    
}

Lwm2m_Server_Object::~Lwm2m_Server_Object(){
    
    for (Resource_Map::iterator it=_resources->begin(); it!=_resources->end(); ++it) {
        delete it->second;
    }
    
    delete _resources;
    
}


string Lwm2m_Server_Object::get_Lifetime(){
    
    return _resources->at(LWM2M_SERVER_LIFETIME_ID)->get_Value();
}

string Lwm2m_Server_Object::get_Binding(){
    
    return _resources->at(LWM2M_SERVER_BINDING_ID)->get_Value();
}



