//Hello Pascal,

//to be able to support MDM in a clustered environment and permanent tcp connection with devices, we had to restrict the supported lwm2m scenario’s to the queued mode only.
//This because jobs launched via the MDM console could be executed by a MDM node of the cluster that doesn’t have a tcp connection with the device.
//With the latest lwm2m plugin, it is up to the device to come to the plugin with a lwm2m Register Update on one of the node and the Job waiting in shared MDM queue will execute.

//To show demo’s this is a bit embarrassing since updates are sent every time device lifetime expires and this could be long.

//So what we have introduced is the ability for the lwm2m plugin to send a Registration Update Trigger to the device if it has an available connection to it.
//In a single node environment this is working fine.

//Can you please check if this registration update trigger can be implemented in the NXP and the freescale so we could upgrade our plugin when required.
//All what is needed is to send a registration update message when then device receive an execute on resource 1/0/8.




#include "mbed.h"
#include "EthernetInterface.h"
#include "C12832_lcd.h"
#include "nsdl_support.h"
#include "dbg.h"
// Include various resources
#include "temperature.h"
#include "light.h"
#include "gps.h"
#include "relay.h"
#include "rgb.h"

#include "firmware.h"
#include "firmware_result.h"
#include "firmware_status.h"

#include "register_upd_trigger.h"

static C12832_LCD lcd;
static PwmOut led1(LED1);
static PwmOut led2(LED2);
static PwmOut led3(LED3);
static PwmOut led4(LED4);

Serial pc(USBTX, USBRX); // tx, rx

// ****************************************************************************
// Configuration section

// Ethernet configuration
/* Define this to enable DHCP, otherwise manual address configuration is used */
#define DHCP 1

// Define this to enable the RGB LED resource
//#define USE_RGBLED 1

/* Manual IP configurations, if DHCP not defined */
#define IP      "10.45.0.206"
#define MASK    "255.255.255.0"
#define GW      "10.45.0.1"

// UDM configuration
/* Change this IP address to that of your NanoService Platform installation */
//static const char* UDM_ADDRESS = "137.135.13.28"; /* demo UDM, web interface at http://red-hat-summit.cloudapp.net*/
//static const char* UDM_ADDRESS = "137.117.164.225"; /* m2mcc02 */
static const char* UDM_ADDRESS = "68.235.31.32"; 
static const int UDM_PORT = 5684;
//char endpoint_name[20] = "ntcmbed-ethernet-";
char endpoint_name[20] = "NXP1768-";
char mbed_uid[33]; // for creating unique name for the board
uint8_t ep_type[] = {"mbed_lpc1768_appboard"};
uint8_t lifetime_ptr[] = {"60"};

static const char* FIRMWARE_VER = "18"; // Committed revision number
char* mac;
char* ipAddr;
char* gateway;
char* nmask;

// ****************************************************************************
// Ethernet initialization

EthernetInterface eth;

static void ethernet_init()
{

    /* Initialize network */
#ifdef DHCP
    NSDL_DEBUG("DHCP in use");
    eth.init();
#else
    eth.init(IP, MASK, GW);
#endif
    if(eth.connect(60000) == 0)
        NSDL_DEBUG("Ethernet up");

    mac = eth.getMACAddress();
    ipAddr = eth.getIPAddress();
    gateway = eth.getGateway();
    nmask = eth.getNetworkMask();
    NSDL_DEBUG("Network: mac=%s, ip=%s, gateway=%s, mask=%s", mac, ipAddr, gateway, nmask);

    mbed_interface_uid(mbed_uid);
    mbed_uid[32] = '\0';
    
    NSDL_DEBUG("Full interface uid=%s", mbed_uid);
    strncat(endpoint_name, mbed_uid + 27, 20 - strlen(endpoint_name));
    
//    EP_NAME = (char*) malloc(strlen(endpoint_name)+1);
//    strcpy(EP_NAME, endpoint_name);    

    lcd.locate(0,11);
    lcd.printf("IP:%s", eth.getIPAddress());

 }

// ****************************************************************************
// UDM initialization

UDPSocket server;
Endpoint udm;

static void udm_init()
{
    server.init();
    server.bind(UDM_PORT);

    udm.set_address(UDM_ADDRESS, UDM_PORT);
    
    NSDL_DEBUG("name: %s", endpoint_name);
    NSDL_DEBUG("UDM=%s - port %d\n", UDM_ADDRESS, UDM_PORT);

    lcd.locate(0,22);
    lcd.printf("EP:%s\n", endpoint_name);
}

// ****************************************************************************
// Resource creation

static int create_resources()
{
    sn_nsdl_resource_info_s *resource_ptr = NULL;
    sn_nsdl_ep_parameters_s *endpoint_ptr = NULL;
    
    NSDL_DEBUG("Creating resources");

    /* Create resources */
    resource_ptr = (sn_nsdl_resource_info_s*)nsdl_alloc(sizeof(sn_nsdl_resource_info_s));
    if(!resource_ptr)
        return 0;
    memset(resource_ptr, 0, sizeof(sn_nsdl_resource_info_s));

    resource_ptr->resource_parameters_ptr = (sn_nsdl_resource_parameters_s*)nsdl_alloc(sizeof(sn_nsdl_resource_parameters_s));
    if(!resource_ptr->resource_parameters_ptr)
    {
        nsdl_free(resource_ptr);
        return 0;
    }
    memset(resource_ptr->resource_parameters_ptr, 0, sizeof(sn_nsdl_resource_parameters_s));

    // Static resources
    nsdl_create_static_resource(resource_ptr, sizeof("3/0/0")-1, (uint8_t*) "3/0/0", 0, 0,  (uint8_t*) "ARM", sizeof("ARM")-1);
    nsdl_create_static_resource(resource_ptr, sizeof("3/0/1")-1, (uint8_t*) "3/0/1", 0, 0,  (uint8_t*) "LPC1768 App Board", sizeof("LPC1768 App Board")-1);
    nsdl_create_static_resource(resource_ptr, sizeof("3/0/2")-1, (uint8_t*) "3/0/2", 0, 0,  (uint8_t*) mbed_uid, sizeof(mbed_uid)-1);
    nsdl_create_static_resource(resource_ptr, sizeof("3/0/3")-1, (uint8_t*) "3/0/3", 0, 0,  (uint8_t*) FIRMWARE_VER, strlen(FIRMWARE_VER));
   #ifdef DHCP
    nsdl_create_static_resource(resource_ptr, sizeof("4/0/0")-1, (uint8_t*) "4/0/0", 0, 0,  (uint8_t*) "Ethernet DHCP", sizeof("Ethernet DHCP")-1);
   #else
    nsdl_create_static_resource(resource_ptr, sizeof("4/0/0")-1, (uint8_t*) "4/0/0", 0, 0,  (uint8_t*) "Ethernet Static", sizeof("Ethernet Static")-1);  
   #endif
    nsdl_create_static_resource(resource_ptr, sizeof("4/0/1")-1, (uint8_t*) "4/0/1", 0, 0,  (uint8_t*) "Ethernet (Static, DHCP)", sizeof("Ethernet (Static, DHCP)")-1);
    nsdl_create_static_resource(resource_ptr, sizeof("4/0/4")-1, (uint8_t*) "4/0/4", 0, 0,  (uint8_t*) ipAddr, strlen(ipAddr));
    nsdl_create_static_resource(resource_ptr, sizeof("4/0/5")-1, (uint8_t*) "4/0/5", 0, 0,  (uint8_t*) gateway, strlen(gateway));
    nsdl_create_static_resource(resource_ptr, sizeof("3/0/16")-1, (uint8_t*) "3/0/16", 0, 0,  (uint8_t*) "UDP", sizeof("UDP")-1);

    // Dynamic resources
    create_temperature_resource(resource_ptr);
    create_light_resource(resource_ptr);
    create_gps_resource(resource_ptr);
    create_relay_resource(resource_ptr);
    create_register_upd_trigger_resource(resource_ptr);
    
    // Dynamic Firmware resources
    create_firmware_resource(resource_ptr);
    create_firmware_result_resource(resource_ptr);
    create_firmware_status_resource(resource_ptr);
    
#ifdef USE_RGBLED
    NSDL_DEBUG("Enabling RGB LED due to USE_RGBLED=%d\n", USE_RGBLED);
    create_rgb_resource(resource_ptr);
#else
    NSDL_DEBUG("Skipped RGB LED resource, change USE_RGBLED to 1 in main.cpp to test");
#endif

    /* Register with UDM */
    endpoint_ptr = nsdl_init_register_endpoint(endpoint_ptr, (uint8_t*)endpoint_name, ep_type, lifetime_ptr);
    if(sn_nsdl_register_endpoint(endpoint_ptr) != 0)
        pc.printf("UDM registering failed\r\n");
    else
        pc.printf("UDM registering OK\r\n");
    nsdl_clean_register_endpoint(&endpoint_ptr);

    nsdl_free(resource_ptr->resource_parameters_ptr);
    nsdl_free(resource_ptr);
    return 1;
}

// ****************************************************************************
// Program entry point

int main()
{
//    strcpy((char*) ep_type, "mbed_lpc1768_appboard");
    strcpy((char*) lifetime_ptr, "60");

    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("NanoService LWM2M v%s", FIRMWARE_VER);
    NSDL_DEBUG("NanoService LWM2M Demo for LPC1768 App Board\n");
    NSDL_DEBUG("NanoService LWM2M version %s\n", FIRMWARE_VER);
    
    // Initialize Ethernet interface first
    ethernet_init();
    
    // Initialize UDM node
    udm_init();
    
    // Initialize NSDL stack
    nsdl_init();
    
    // Create NSDL resources
    create_resources();
  
    //Version 18
     led3.write(0.1);

    //Version 19
//    led2.write(0.5);
//    led3.write(0.5);
    
    // Run the NSDL event loop (never returns)
    nsdl_event_loop();
}
