#include <mbed.h>
#include <scrp_slave.hpp>

//パソコンのScrpMonitorから送った信号をそのままRS485で送信します。
//USBで受信したデータをMILLポートから出力します。
//cmd 0,253,254は使えません。

ScrpSlave slave(PA_9 ,PA_10,PA_12,SERIAL_TX,SERIAL_RX,255);//全受信モード

bool rs485(int rx_data, int &tx_data){
    if(slave.receivePort() == 1){//USBから受信した時にMILLポートから送信する。
        slave.send1(slave.receiveId(), slave.receiveCmd(), rx_data);
    }
    return false;
}

void response(uint8_t id,uint8_t cmd, int16_t data){
    slave.send2(id, cmd, data, false);//返ってきたレスポンスをUSBに送信する。
}

int main(){
    for(int i = 0;i < 256;i++){
        slave.addCMD(i, rs485);
    }
    slave.attachResponse(response);
    while(true);
}