/*
 * VFD Modular Clock - mbed
 * (C) 2011-14 Akafugu Corporation
 *
 * This program is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU General Public License for more details.
 *
 */

#ifndef FEATURES_H_
#define FEATURES_H_

#define YES 2
#define NO  1

///////////////////////////////////////////

#if !(defined FEATURE_3BUTTON) || FEATURE_3BUTTON < NO || FEATURE_3BUTTON > YES
#  error Must define FEATURE_3BUTTON to be YES or NO
#endif

#if FEATURE_3BUTTON == YES
#define HAVE_3BUTTON
#endif

///////////////////////////////////////////

#if !(defined FEATURE_GPS) || FEATURE_GPS < NO || FEATURE_GPS > YES
#  error Must define FEATURE_GPS to be YES or NO
#endif

#if FEATURE_GPS == YES
#define HAVE_GPS
#endif

///////////////////////////////////////////

#if !(defined FEATURE_DS1302) || FEATURE_DS1302 < NO || FEATURE_DS1302 > YES
#  error Must define FEATURE_DS1302 to be YES or NO
#endif

#if FEATURE_DS1302 == YES
#define HAVE_DS1302
#endif

///////////////////////////////////////////

#if !(defined FEATURE_DS3231M) || FEATURE_DS3231M < NO || FEATURE_DS3231M > YES
#  error Must define FEATURE_DS3231M to be YES or NO
#endif

#if FEATURE_DS3231M == YES
#define HAVE_DS3231M
#endif

#if FEATURE_DS1302 == YES && FEATURE_DS3231M == YES
#  error Use either FEATURE_DS1202 or FEATURE_DS3231M, not both
#endif

#endif /* FEATURES_H_ */
