/*
 * GPS support for VFD Modular Clock
 * (C) 2012 William B Phelps
 *
 * mbed Port (C) 2014 Akafugu Corporation
 *
 * This program is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU General Public License for more details.
 *
 */

#ifndef GPS_H_
#define GPS_H_

#ifdef HAVE_GPS

#include "mbed.h"

//convenience macro to convert to and from tm years
#define  tmYearToY2k(Y)      ((Y) - 100)    // offset is from 1900
#define  y2kYearToTm(Y)      ((Y) + 100)

// String buffer size:
#define GPSBUFFERSIZE 96 
//The year the clock was programmed, used for error checking
#define PROGRAMMING_YEAR 14

#define SECS_PER_HOUR (3600UL)

extern unsigned long tGPSupdate;  // really time_t

// we double buffer: read into one line and leave one for the main program
//extern volatile char gpsBuffer1[GPSBUFFERSIZE];
//extern volatile char gpsBuffer2[GPSBUFFERSIZE];
// our index into filling the current line
//extern volatile uint8_t gpsBufferPtr;
// pointers to the double buffers
//extern volatile char *gpsNextBuffer;
//extern volatile char *gpsLastBuffer;
//extern volatile uint8_t gpsDataReady_;

//GPS serial data handling functions:
uint8_t gpsDataReady(void);
void GPSread(char c);
char *gpsNMEA(void);
time_t parseGPSdata(char *gpsBuffer, bool& error, bool& fix, int8_t tzh, uint8_t tzm);

uint8_t leapyear(uint16_t y);
void gps_init();

#endif // HAVE_GPS
#endif // GPS_H_
