/*
 * VFD Modular Clock - mbed
 * (C) 2011-14 Akafugu Corporation
 *
 * This program is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU General Public License for more details.
 *
 */

#include "mbed.h"

/// VFD Modular Clock - SMT mbed IV-18
#if defined(TARGET_LPC11U24) || defined(TARGET_LPC1347)

#define FEATURE_3BUTTON  YES
#define FEATURE_GPS      YES
#define FEATURE_DS1302    NO
#define FEATURE_DS3231M  YES

struct PinMap {
    static const PinName data  = P0_18;
    static const PinName clock = P0_17;
    static const PinName latch = P0_19;
    static const PinName blank = P0_13;
    
    static const PinName button2 = P1_28;  // button
    static const PinName button1 = P0_7; // button
    static const PinName button3 = P0_1;  // button
    
    // RTC
    static const PinName sda = P0_5;
    static const PinName scl = P0_4;
    
    // Other
    static const PinName piezo = P0_9;
    static const PinName led = P1_16;
    //static const PinName tx = P1_13;
    //static const PinName rx = P1_14;
    static const PinName ext1 = P1_19;
    static const PinName ext2 = P1_20;
};

#endif

/// VFD Modular Clock - mbed test board
#ifdef TARGET_LPC1114

#define FEATURE_3BUTTON  NO
#define FEATURE_GPS     YES
#define FEATURE_DS1302   NO
#define FEATURE_DS3231M YES

struct PinMap {
    // VFD Driver
    static const PinName data  = dp14;
    static const PinName clock = dp10;
    static const PinName latch = dp13;
    static const PinName blank = dp1;

    // Buttons / switches
    static const PinName button1 = dp26; // button
    static const PinName button2 = dp24; // button
    static const PinName button3 = dp28; // switch
    
    // Board signature
    static const PinName sig0 = dp4;
    static const PinName sig1 = dp2;
    static const PinName sig2 = dp6;

    // Other
    static const PinName piezo = dp18;
    static const PinName led = dp25;
    static const PinName sqw = dp17;
    static const PinName tx = dp16;
    static const PinName rx = dp16;
    static const PinName ext1 = dp9;
    static const PinName ext2 = dp11;
};

#endif

/// VFD Modular Clock - mbed test board
#ifdef TARGET_LPC1549

#define FEATURE_3BUTTON  NO
#define FEATURE_GPS      NO
#define FEATURE_DS1302   NO
#define FEATURE_DS3231M YES

struct PinMap {
    // VFD Driver
    static const PinName data  = A5;
    static const PinName clock = D13; // P0_16
    static const PinName latch = A4;
    static const PinName blank = D5;
    /*
    static const PinName data  = P0_22; // A5
    static const PinName clock = P0_16; // D13
    static const PinName latch = P0_23; // A4
    static const PinName blank = P0_16; // D5
    */

    // Buttons / switches
    static const PinName button1 = D8;
    static const PinName button2 = D7;
    static const PinName button3 = D2;
    /*
    static const PinName button1 = P0_24; // button D8
    static const PinName button2 = P0_0; // button D7
    static const PinName button3 = P0_29; // switch D2
    */
    
    // Board signature
    static const PinName sig0 = A0; //P0_8
    static const PinName sig1 = A1; //P0_7
    static const PinName sig2 = A2; //P0_6
    
    // Other
    static const PinName piezo = D4; // P0_10
    static const PinName led = D9; // P1_0
    //static const PinName sqw = P1_3; // D6
    //static const PinName tx = P0_18; // D1
    //static const PinName rx = P0_13; // D0
    static const PinName ext1 = A3; // P0_5
    static const PinName ext2 = D3; // P1_2
    
    // I2C
    //static const PinName sda = 
    //static const PinName scl =
};

#endif


/// VFD Modular Clock - BLE
#ifdef TARGET_NRF51822

#define FEATURE_3BUTTON  NO
#define FEATURE_GPS      NO
#define FEATURE_DS1302   NO
#define FEATURE_DS3231M YES

struct PinMap {
    static const PinName data  = P0_15;
    static const PinName clock = P0_12;
    static const PinName latch = P0_13;
    static const PinName blank = P0_13;
    
    static const PinName button1 = P0_1;
    static const PinName button2 = P0_1;
};

#endif

#include "features.h"

// display state
typedef enum {
  // basic states
  STATE_CLOCK = 0,    // shows hh-mm-ss / hh.mm.ss / hh.mm.ss.x depending on g_display_mode
  STATE_SHOW_ALARM,   // shows current alarm for a brief time
  STATE_ALARMING,     // alarm is going off
  STATE_AUTO_DATE,    // scroll date across the screen
  STATE_AUTO_FLW,     // show FLW briefly
  STATE_AUTO_TEMP,    // show temperature briefly
  STATE_SET_ALARM_HH, // set alarm, hours
  STATE_SET_ALARM_MM, // set alarm, minutes
  STATE_SET_CLOCK_HH, // set clock, hours 
  STATE_SET_CLOCK_MM, // set clock, minutes 
  STATE_SET_CLOCK_SS, // set clock, seconds
  STATE_FLW,          // four letter word
  STATE_TEMP,         // temperature
  STATE_MENU,         // menu
} state_t;
