#include "beep.h"
#include "mbed.h"

/** class to make sound with a buzzer, based on a PwmOut
 *   The class use a timeout to switch off the sound  - it is not blocking while making noise
 *
 * Example:
 * @code
 * // Beep with 1Khz for 0.5 seconds
 * #include 'mbed.h'
 * #include 'beep.h'
 * 
 * Beep buzzer(p21);
 * 
 * int main() {
 *       ...
 *   buzzer.beep(1000,0.5);    
 *       ...
 * }
 * @endcode
 */

//using namespace mbed;
 // constructor
 /** Create a Beep object connected to the specified PwmOut pin
  *
  * @param pin PwmOut pin to connect to 
  */
    
Beep::Beep(PinName pin) : _pwm(pin) {
    _pwm.write(0.0);     // after creating it have to be off
}

 /** stop the beep instantaneous 
  * usually not used 
  */
void Beep::nobeep() {
    _pwm.write(0.0);
}

/** Beep with given frequency and duration.
 *
 * @param frequency - the frequency of the tone in Hz
 * @param time - the duration of the tone in seconds
 */
     
void Beep::beep(float freq, float time) {

    _pwm.period(1.0/freq);
    _pwm.write(0.5);            // 50% duty cycle - beep on
    toff.attach(this,&Beep::nobeep, time);   // time to off
}

#define NOTE_GB 0
#define NOTE_EB 1
#define NOTE_FS 2

void Beep::play(char note) {
    if (note=='a') {
        beep(880,0.1);
    }
    if (note=='b') {
        beep(987,0.1);
    }
    if (note=='c') {
        beep(1024,0.1);
    }
    if (note=='d') {
        beep(1175,0.1);
    }
    if (note=='e') {
        beep(1319,0.1);
    }
    if (note=='f') {
        beep(1397,0.1);
    }
    if (note=='g') {
        beep(1568,0.1);
    }

    if (note==NOTE_GB) {
        beep(830,0.1);
    }
    if (note==NOTE_EB) {
        beep(659,0.1);
    }
    if (note==NOTE_FS) {
        beep(1480,0.1);
    }
    if (note=='w') {
        wait(0.05);
    }
    wait (0.2); //wait while the note plays.
}

void Beep::popcorn() {

    play('e');
    play('d');
    play('e');
    play('c');
    play(NOTE_GB);
    play('c');
    play(NOTE_EB);
    play('w');
    play('e');
    play('d');
    play('e');
    play('c');
    play(NOTE_GB);
    play('c');
    play(NOTE_EB);
    play('w');
    play('e');
    play(NOTE_FS);
    play('g');
    play(NOTE_FS);
    play('g');
    play('e');
    play(NOTE_FS);
    play('e');
    play(NOTE_FS);
    play('d');
    play('e');
    play('d');
    play('e');
    play('d');
    play('e');
    play('w');
    play('e');
    play('d');
    play('e');
    play('c');
    play(NOTE_GB);
    play('c');
    play(NOTE_EB);
    play('w');
    play('e');
    play('d');
    play('e');
    play('c');
    play(NOTE_GB);
    play('c');
    play(NOTE_EB);
    play('w');
    play('e');
    play(NOTE_FS);
    play('g');
    play(NOTE_FS);
    play('g');
    play('e');
    play(NOTE_FS);
    play('e');
    play(NOTE_FS);
    play('d');
    play('e');
    play('d');
    play('e');
    play('d');
    play('g');

}

