/*
 * VFDDeluxe / Simpleclock VFD - mbed
 * (C) 2011-14 Akafugu Corporation
 *
 * This program is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU General Public License for more details.
 *
 */


#ifndef __IV18_DISPLAY_H_
#define __IV18_DISPLAY_H_

#include "mbed.h"
#include "VFDDisplay.h"

class IV18Display : public VFDDisplay
{
public:
    IV18Display(PinName data, PinName clock, PinName latch, PinName blank);
    
    virtual void writeDisplay(uint8_t digit, uint16_t segments);
    //virtual void printTime(time_t t, uint8_t hundredths);
    virtual void printTime(struct tm* tm, uint8_t hundredths);
    virtual void printTimeLong(struct tm* tm, uint8_t hundredths);
    virtual void printTimeSet(struct tm* tm, bool showSeconds = true);
    virtual void printDate(struct tm* tm);

private:
    virtual uint16_t calculateSegments(char c, uint8_t digit);
    virtual void handleBlink(char d);
};
    
#endif // __IV18_DISPLAY_H_
