/*
 * VFD Modular Clock - mbed
 * (C) 2011-14 Akafugu Corporation
 *
 * This program is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU General Public License for more details.
 *
 */

#ifndef PREFS_H_
#define PREFS_H_

const uint8_t PREFS_SIZE = 12;

enum PREFS {
    PREF_24H = 0,
    PREF_BRIGHTNESS,
    PREF_ALARM,
    PREF_DOTS,
    PREF_GPS,
    PREF_GPS_TZH,
    PREF_GPS_TZM,
    PREF_AUTODATE,
    PREF_FLW,
    // Prefs that are not saved to eeprom
    PREF_SET_TIME,
    PREF_SET_ALARM,
    PREF_YEAR,
    PREF_MONTH,
    PREF_DAY,
    PREF_NULL // placeholder
};

struct prefs_t {
    uint8_t sig0; // expected 0x42
    uint8_t sig1; // expected 0x66
    uint8_t disp_24h;
    uint8_t brightness;
    uint8_t alarm;
    uint8_t dots;
    uint8_t gps;
    int8_t  gps_tzh;
    uint8_t gps_tzm;
    uint8_t auto_date;
    uint8_t flw;
    uint8_t crc;
};

union PrefsData {
    uint8_t buf[12];
    prefs_t prefs;
};

void init_prefs();
void save_prefs();
PrefsData* get_prefs();

// prefs that are not saved to EEPROM
void set_year(int year);
void set_month(int month);
void set_day(int day);

void set_extra_prefs(int year, int month, int day);
void get_extra_prefs(int& year, int& month, int& day);

void set_pref(PREFS pref, uint32_t value);

#endif // PREFS_H_
