/*
 * VFD Modular Clock - mbed
 * (C) 2011-14 Akafugu Corporation
 *
 * This program is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU General Public License for more details.
 *
 */

#ifndef MENU_H_
#define MENU_H_

// menu type
//
// custom routine (set time, set alarm)
// on-off (24h on, off)
// array of possible values (flw: off, on, full)
// range (brite 1-10)
//
// values always stored as numbers

#define MAX_BUF 9

#include "prefs.h"

class MenuItemValue {
private:
    int32_t m_min;
    int32_t m_max;
    int32_t m_value;
    bool m_activated;
public:
    MenuItemValue(int32_t min, int32_t max);

    int32_t getValue();
    int32_t incrementValue();
    void resetActive();
};

class MenuItem {
private:
    char m_shortName[5];
    char m_longName[MAX_BUF];
    bool m_onOff;
    PREFS m_pref;
    
    MenuItemValue* m_menuItemValue;
public:
    MenuItem(const char* shortName, const char* longName, bool onOff, PREFS pref);
    MenuItem(const char* shortName, bool onOff, PREFS pref);

    MenuItem(const char* shortName, const char* longName, int32_t min, int32_t max, PREFS pref);
    MenuItem(const char* shortName, int32_t min, int32_t max, PREFS pref);
    
    const char* getName(uint8_t digits) const;
    const char* selectValue(uint8_t digits) const;
    void resetActive() const;
    
    bool isSetTimeTrigger() const { return m_pref == PREF_SET_TIME; }
    bool isSetAlarmTrigger() const { return m_pref == PREF_SET_ALARM; }
};

class Menu {
private:
    uint8_t m_position;
    uint8_t m_size;
    uint8_t m_digits;
        
public:
    Menu();
    
    void setDigits(uint8_t digits) { m_digits = digits; }
    
    const char* reset();
    const char* next();
    const char* select(bool& enterSetTime, bool& enterSetAlarm);
    void leave();
};

#endif // MENU_H_
