/*
 * Four Letter Word Generator
 * (C) 2015 Akafugu Corporation
 *
 * This program is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU General Public License for more details.
 *
 */

#ifndef FLW_H__
#define FLW_H__

#include <inttypes.h>
#include <stdbool.h>

#include "_24LCXXX.h"

class FourLetterWordBase
{
protected:
    bool m_censored;
    unsigned long m_offset;
    char m_current_word[6];
    uint32_t m_lfsr;
    
    uint32_t randomize();
    
    void rot13(char* w);
    bool binary_search(const char *key, int imin, int imax);
    
    char* get_word_censored();
    char* get_word_uncensored();

public:
    FourLetterWordBase() :
        m_censored(true),
        m_offset(0),
        m_lfsr(0xbeefcace) {}

    virtual uint8_t read_byte(unsigned int addr) = 0;
    virtual void read_buffer(unsigned int addr, uint8_t *buffer, int length) = 0;

    void begin(uint32_t seed = 0xbeefcace, bool censored = true);
    void setCensored(bool c) { m_censored = c; }
    bool hasEeprom();
    char* getWord(bool adjustCase = false);
};

class FourLetterWord : public FourLetterWordBase
{
private:
    _24LCXXX _24lc;
    
public:
    FourLetterWord(I2C *i2c, uint8_t addr = 0x50) : FourLetterWordBase(), _24lc(i2c, addr) {}

    virtual uint8_t read_byte(unsigned int addr);
    virtual void read_buffer(unsigned int addr, uint8_t *buffer, int length);
};

extern const unsigned char flw_data[];

class FourLetterWordLocal : public FourLetterWordBase
{
private:
    const unsigned char* data; 

public:
    FourLetterWordLocal() : FourLetterWordBase(), data(flw_data) {}

    virtual uint8_t read_byte(unsigned int addr);
    virtual void read_buffer(unsigned int addr, uint8_t *buffer, int length);
};

#endif