/*
 * RTC library - mbed
 * (C) 2011-15 Akafugu Corporation
 *
 * This program is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU General Public License for more details.
 *
 */

#include "rtc.h"

RTC::RTC() : m_time(1388534400+40000+60)
{
    m_tenths = 0;
}

void RTC::begin()
{
}

void RTC::tick()
{
    m_time++;
    m_tenths = 0;
}

void RTC::tenth_tick()
{
    m_tenths++;    
}

time_t RTC::time()
{
    return m_time;
}

struct tm* RTC::getTime()
{
    struct tm *tmp = localtime(&m_time);     
    return tmp;
}

void RTC::getTime(uint8_t* hour, uint8_t* min, uint8_t* sec)
{

}

void RTC::setTime(time_t t)
{
    m_time = t;
}

void RTC::setTime(uint8_t hour, uint8_t min, uint8_t sec)
{
}

void RTC::setTime(struct tm* tm)
{
}

void RTC::setAlarm(time_t t)
{
}

void RTC::setAlarm(uint8_t hour, uint8_t min, uint8_t sec)
{
}

struct tm* RTC::getAlarm(void)
{
    return 0;
}

void RTC::getAlarm(uint8_t* hour, uint8_t* min, uint8_t* sec)
{
}

bool RTC::checkAlarm(void)
{
    return false;
}

void RTC::SQWEnable(bool enable)
{
}

void RTC::SQWSetFreq(enum RTC_SQW_FREQ freq)
{
}

uint8_t RTC::dec2bcd(uint8_t d)
{
    return ((d/10 * 16) + (d % 10));
}

uint8_t RTC::bcd2dec(uint8_t d)
{
    return(((d&0xF0)>>4) * 10 + (d&0x0F));
}

