/*
 * RTC library - mbed
 * (C) 2011-15 Akafugu Corporation
 *
 * This program is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU General Public License for more details.
 *
 */

#ifndef __RTC_H_
#define __RTC_H_

#include "mbed.h"

class RTC {
protected:
    struct tm m_tm;
    time_t m_time;
    uint8_t m_tenths;

public:
    RTC();
    
    enum RTC_SQW_FREQ { FREQ_1 = 0, FREQ_1024, FREQ_4096, FREQ_8192 };
    
    virtual void begin();

    void tick();
    void tenth_tick();

    virtual time_t time();
    virtual struct tm* getTime();
    virtual void getTime(uint8_t* hour, uint8_t* min, uint8_t* sec);

    virtual void setTime(time_t t);
    virtual void setTime(uint8_t hour, uint8_t min, uint8_t sec);
    virtual void setTime(struct tm* tm);

    virtual void setAlarm(time_t t);
    virtual void setAlarm(uint8_t hour, uint8_t min, uint8_t sec);
    virtual struct tm* getAlarm(void);
    virtual void getAlarm(uint8_t* hour, uint8_t* min, uint8_t* sec);
    virtual bool checkAlarm(void);
    
    virtual void SQWEnable(bool enable);
    virtual void SQWSetFreq(enum RTC_SQW_FREQ freq);
    
    uint8_t getTenths() { return m_tenths; }
    
protected:
     uint8_t bcd2dec(uint8_t d);
     uint8_t dec2bcd(uint8_t d);
};

#endif // __RTC_H_
