/*
 * RTC library - mbed
 * (C) 2011-15 Akafugu Corporation
 *
 * This program is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU General Public License for more details.
 *
 */

#ifndef __DS3231M_H_
#define __DS3231M_H_

#include "rtc.h"

// leap year calulator expects year argument as years offset from 1970
#define LEAP_YEAR(Y)     ( ((1970+Y)>0) && !((1970+Y)%4) && ( ((1970+Y)%100) || !((1970+Y)%400) ) )
/* Useful Constants */
#define SECS_PER_MIN  (60UL)
#define SECS_PER_HOUR (3600UL)
#define SECS_PER_DAY  (SECS_PER_HOUR * 24UL)
#define DAYS_PER_WEEK (7UL)
#define SECS_PER_WEEK (SECS_PER_DAY * DAYS_PER_WEEK)
#define SECS_PER_YEAR (SECS_PER_WEEK * 52UL)
#define SECS_YR_2000  (946684800UL) // the time at the start of y2k

class DS3231M : public RTC {
public:
    DS3231M(I2C& i2c);
    
    virtual void begin();
    
    virtual time_t time();
    virtual struct tm* getTime();
    virtual void getTime(uint8_t* hour, uint8_t* min, uint8_t* sec);

    virtual void setTime(time_t t);
    virtual void setTime(struct tm* tm);
    virtual void setTime(uint8_t hour, uint8_t min, uint8_t sec);

    virtual void setAlarm(time_t t);
    virtual void setAlarm(uint8_t hour, uint8_t min, uint8_t sec);
    virtual struct tm* getAlarm(void);
    virtual void getAlarm(uint8_t* hour, uint8_t* min, uint8_t* sec);
    virtual bool checkAlarm(void);
    
    virtual void SQWEnable(bool enable);
    virtual void SQWSetFreq(enum RTC_SQW_FREQ freq);
    virtual void Osc32kHzEnable(bool enable);
    
    // Temperature
    void getTemp(int8_t* i, uint8_t* f);
    void forceTempConversion(uint8_t block);

private:
    I2C& m_i2c;

    bool m_is_ds1307;
    bool m_is_ds3231;

    uint8_t read_byte(uint8_t offset);
    void write_byte(uint8_t b, uint8_t offset);
    void write_addr(uint8_t addr);
};

#endif // __DS3231M_H_
