/*
 * RTC library - mbed
 * (C) 2011-15 Akafugu Corporation
 *
 * This program is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU General Public License for more details.
 *
 */

#ifndef __DS1307_H_
#define __DS1307_H_

#include "rtc.h"

class DS1307 : public RTC {
public:
    DS1307(I2C& i2c);    

    virtual void begin();
    
    virtual time_t time();
    virtual struct tm* getTime();
    virtual void getTime(uint8_t* hour, uint8_t* min, uint8_t* sec);

    virtual void setTime(time_t t);
    virtual void setTime(struct tm* tm);
    virtual void setTime(uint8_t hour, uint8_t min, uint8_t sec);

    virtual void setAlarm(time_t t);
    virtual void setAlarm(uint8_t hour, uint8_t min, uint8_t sec);
    virtual struct tm* getAlarm(void);
    virtual void getAlarm(uint8_t* hour, uint8_t* min, uint8_t* sec);
    virtual bool checkAlarm(void);
    
    virtual void SQWEnable(bool enable);
    virtual void SQWSetFreq(enum RTC_SQW_FREQ freq);
    
    // start/stop clock running
    void runClock(bool run);
    bool isClockRunning(void);

private:
    I2C& m_i2c;
    
    uint8_t read_byte(uint8_t offset);
    void write_byte(uint8_t b, uint8_t offset);
    
    void writeRam(uint8_t addr, uint8_t data);
    uint8_t readRam(uint8_t addr);
};


#endif // __DS1307_H_