#include "SpeedCalculate.h"
#include "mbed.h"
#include "Data.h"
#include <time.h>
#include <string>


extern Serial pc;
 
//c++ variables
Timer t; //time at which sensor is broken
float timeDiff; //time between 2 sensors  
float speed; //array of speeds 
    

//Speed Calculations
//it takes the distance and number of sensor and gives the speed (m/s)
void SpeedCalculate::calculate(float distance, int noOfSensors)
{
    Data data;
    
    int count = 0;
    
    //array of sensors
    DigitalIn sensor[18] =  {p5, p6, p7, p8, p11, p12, p13, p14, p15, p16, p17, p18, p19, p20, p21, p22, p23, p24};
    
    while(true){
        int i=0;
        t.start();
        data.counter(count);
        while( i < noOfSensors) //loops round until all the sensors have been used
        {
            if (i == 0){
                data.logSpeed(0,0,0);
                }
            while(!sensor[i]) 
            {
                if(sensor[i + 1]) { //checks if there is an error in the first sensor
                    i++; 
                    }
                if(sensor[i + 2]) { //checks if there is an error in the second sensor after
                    i = i + 2; 
                    }                                                          
            }
            timeDiff = t.read(); //gets current time
            t.reset();
            pc.printf("%f\n%f\n", i, timeDiff);  
            if ( i > 0) { //to ensure it is not the first one
                    speed = 60*(distance / timeDiff);
                    pc.printf("%f\n", speed); 
                    data.logSpeed(&i, &timeDiff, &speed); //logs data
            }         
            i++;
        }
        t.stop();
        count++;
    } 
}
