#include "mbed.h"
#include <time.h>
#include <string>
#include <iostream>
#include "Data.h"

//*************defining methods used in this method
void printArray(double array[20], double timesArray[20], int NoOfPins,double speedAvg[20], double timesTotal[20], string date);                                     
void data(int sensor_number, double time, double speed, double timesTotal, double speedAvg);  
void reset(int distance, int NoOfPins, string date);
                                                
 //*********mbed pins*********************************
extern Serial pc;                                                                   //defines the communication between MBed and pc       
DigitalIn sensor[20] = {p5,p6,p7,p8,p9,p10,p11,p12,p13,p14,p15,p16,p17,p18,p19,p20,p21,p22,p23,p24} ; //array of sensors.  
DigitalOut led4(LED4); 

//********c++ variables*******************************
    
    Timer t;
    double timeDiff= 0;                          //time between 2 sensors  
    double speed = 0;                           //instspeed
    double avgtime= 0;;                                 
    double avgspeed = 0;
    double avgdistance = 0;
    int bendCounter = 0;
    //arrays
    double times[20];                                //array of the time the sensor is reached .(the size of #pins)
    double speeds[20];                                //array of inst speeds 
    double avgSpeeds[20];                             //avg speeds
    double totalTimes[20];                             //total runnning times 
   

int calculate(double distance, int NoOfPins, string date)                  //run when the pipe is being bent around the former.
{     
while(true)                                                       //keep doing this
{   
    int i = 0;                                          //set the pin to 0, starting from the 0th ( first) pin
    while( i < NoOfPins)                                //while we have not reached the last pin
    {
                while(!sensor[i])                                       //while the sensor is not broken hold it. 
                {
                    if(sensor[i + 1])                                       //bit of error bypassing - if the next sensor is hit
                     {
                        //printf("it skipped sensor % d", i);
                        led4 = 1;                                           //alerts user that a sensor has been skipped. 
                        i++;                                                //keep going on as normal
                        
                    }                                                        
                }
                t.start();                                                           //starts the timer once, doesn't do anything next iteration
                                                                               
                timeDiff =  t.read();                                                       //reads what the timer is currently at. Getting the time between each sensor
                t.reset();                                                                 //starts the timer again from 0.
                times[i] = timeDiff;                                                 //adds sensor times to array for logging.  This must remain above the calculations for avgdistance to work.
                
                if( i <1 )                                                        //for the first iteration so it prints out 0 instead of getting inf by dividing 0 and getting nan symbols.
                {
                     printf("0\n");
                     printf("0\n");
                     printf("0\n");
                     printf("0\n");
                     printf("1\n");
                     i++;   
                }
                else                                                            //otherwise if it is not the first one do this
                {
                            pc.printf(" timediff: %lf\n", timeDiff);                            //displays the timediff between each sensor at the top of the GUI
                                   
                                   //*****************Inst Speed *************************
                                     speed = 60* (distance / timeDiff);                //instaneous speed between each sensor.  Multiplied by 60 to get meters per minute
                                     //*******average speed*******************************
                                     avgdistance = distance * i;                        //total distance = distance between each sensor multiplied by number of sensors                                    
                                        avgtime = times[1] + times[2] + times[3] + times[4] + times[5] + times[6] + times[7] + times[8] + times[9] +times[10] + times[11] + times[12]+times[13] + times[14] + times[15]+times[16] + times[17] + times[18]+ times[19] ;                      //total time sum of all times
                                        //gets the total time it has taken. Adds up all the inst speeds. (Could start another timer and read it without resets but I don't think there is a beneficial difference)
                                     pc.printf("avgtime: %f \n", avgtime);                  //print the average time for the top bit for checking/testing
                                    avgspeed = 60*(avgdistance / avgtime);                  //multiplied by 60 to get meters per minute
                                    
                                    //******send to GUI****************************************
                                     pc.printf("%f\n", speed);            //inst speed printed  
                                     pc.printf("%f\n", avgspeed);        //avg speed printed
                                     pc.printf("%d \n",i+1);                //which sensor it is on printed
                                     //*********add to array*************************************
                                     speeds[i] = speed;                     //save inst speeds.
                                     avgSpeeds[i] = avgspeed;               //save avg speeds 
                                     totalTimes[i] = avgtime;               //save total times
                                       i++;                           //move onto next sensor                                   
             } 
        }
        
         printArray(speeds,times,NoOfPins,avgSpeeds,totalTimes, date);            //write info to Mbed xl
        reset(distance, NoOfPins, date);                                          //reset after all sensors on former have been used. Prepare for it to start from the start again.
}
}

void reset(int distance, int NoOfPins, string date)                                  //reset after all sensors on former have been used. Prepare for it to start from the start again.     
{
    while ( sensor[0]){
        
        }
        wait_ms(50);                                                        //give it some time
        bendCounter++;                                                      //increment the bendcounter, used in the xl doc to record which bend is which
        //*******resets c# display to null**************           
         pc.printf("\n" );
         pc.printf("\n" );
         pc.printf("\n" );
         pc.printf("\n" );
         pc.printf("%d\n", 0);
         
        //*****8resets arrays to all 0 ************    
         std::fill_n(times, 20 , 0);        //empty array of times so averaging works
         std::fill_n(speeds, 20 , 0);
         std::fill_n(avgSpeeds, 20 , 0);
         std::fill_n(totalTimes, 20 , 0);
         t.reset(); //clock reset
         
         //******start again************
        calculate(distance, NoOfPins, date);  //be ready for another bend on same former.
}

void printArray(double array[20], double timesArray[20], int NoOfPins, double speedAvg[20], double timesTotal[20], string date)              //for printing arrays to xl doc on the mbed.
      {
          initialise(bendCounter, date);                                 //used to create the Datalog file header.Should happen once for every bend test. BendCounter is the iteration of the bend
         for (int i = 0; i < NoOfPins ; i++)                                 //for every sensor                         
        {
             data( i,times[i],speeds[i],timesTotal[i],speedAvg[i]);            //printing to Datalog    
         }
      }
