#ifndef BASE_H
#define BASE_H

#include "MODSERIAL.h"

extern MODSERIAL gps; //GPS
extern MODSERIAL pc;
extern MODSERIAL bluetooth;

extern DigitalOut ledGREEN;
extern DigitalOut ledRED;

extern DigitalOut led1;
extern DigitalOut led2;
extern DigitalOut led3;
extern DigitalOut led4;


extern int gyro_pos;
extern int _ID;

extern int antenna_active;//do we have an antenna connected?

extern double antennaheight;
extern int _btMode; // 0=Send Everything, 1 = No GPS, 2 = Receive only

//Steering
extern double lookaheadtime;
extern double scale;
extern double phaseadv;
extern double tcenter;
//extern double fgain;
extern double filterg;
extern double avgpos;
// in prevision of PID addition to FreePilot
extern double kp;
extern double ki;
extern double kd;

extern int gps_baud; //default at 115200, but FGPS will pass the real baud-rate.

//offsets
extern double w_xBias;
extern double w_yBias;
extern double w_zBias;
extern double a_xBias;
extern double a_yBias;
extern double a_zBias;

extern bool Authenticated;

void activate_antenna();

void process_GPSBAUD(char* gpsbaud);

void Dispatch(char* line, bool config = false);



#endif
