#include "mbed.h"
#include <string>
#include "Config.h"
#include "base.h"

LocalFileSystem local("local"); // Create the local filesystem under the name "local"
char* line;

void Config_Startup()
{
    FILE * fp;
    char line[256];

    //fp = fopen("/local/config.txt", "w");
    //fprintf(fp, "BT,000666624C6A\r\nPA,0\r\nTC,4.5\r\nFG,30\r\nSC,2.7\r\nAP,-4"); //Rewrite text file for TESTING
    //fclose(fp);

    fp = fopen("/local/config.txt", "r");

    while (fgets(line, sizeof(line), fp)) //Read through config file line by line
    {
        
 pc.puts(line);
        Dispatch(line, true); //Send line to dispatcher, true indicates its coming from the config file
}
    fclose(fp);
}

void Config_Save()
{
    FILE * fp;
    fp = fopen("/local/config.txt", "w");
    //sprintf("$ID,%d\r\n$BTMODE,%d\r\n$PA,%f\r\n$TC,%f\r\n
fprintf(fp, "$ID,%d\r\n",_ID);//address
fprintf(fp, "$BTMODE,%d\r\n",_btMode);//bluetooth mode
fprintf(fp, "$PA,%f\r\n",phaseadv);//phase advance
fprintf(fp, "$TC,%f\r\n",tcenter);//tcenter
fprintf(fp, "$FG,%f\r\n", filterg );//filter gain
fprintf(fp, "$SC,%f\r\n",scale);//scale
fprintf(fp, "$AP,%f\r\n",avgpos);//avgpos
fprintf(fp,"$GYRO,%i\r\n",gyro_pos);
fprintf(fp,"$GPSBAUD,%d\r\n",gps_baud);
fprintf(fp,"$HEIGHT,%f\r\n",antennaheight);
fprintf(fp,"$PID,%f,%f,%f\r\n", kp,ki,kd);
fprintf(fp, "$LOOKA,%f\r\n", lookaheadtime);//lookahead time

    fclose(fp);
}

int Config_SetID()
{
    char mac[6];
    mbed_mac_address(mac);
    return( mac[3] << 16 | mac[4] << 8  | mac[5] << 0);
} 

int Config_GetID()
{
    char mac[6];
    mbed_mac_address(mac);
    int id = mac[3] << 16 | mac[4] << 8  | mac[5] << 0; // Bytes 4-6 form the unique idenfitfier

    return id;
}
