#include "Venus838.h"

// A0 A1 PL(2b) ID Body CS 0D 0A
Venus838::Venus838(PinName tx, PinName rx) : _gps(tx, rx) {
    _gps.baud(115200);
}

void Venus838::setNmeaMessages(const bool gga, const bool gsa, const bool gsv, const bool gll, const bool rmc, const bool vtg) {
    char cmd[16] = {
        0xA0, 0xA1, 0x00, 0x09,
        0x08, gga, gsa, gsv, gll, rmc, vtg, 0x00, 0x01,
        0x00, 0x0D, 0x0A
    };
    for(int i = 4; i < 13; i++) cmd[13] ^= cmd[i];
    for(int i = 0; i < 16; i++) _gps.putc(cmd[i]);
}

void Venus838::setUpdateRate(const uint8_t rate) {
    char cmd[10] = {
        0xA0, 0xA1, 0x00, 0x03,
        0x0E, rate, 0x01,
        0x00, 0x0D, 0x0A
    };
    for(int i = 4; i < 7; i++) cmd[7] ^= cmd[i];
    for(int i = 0; i < 10; i++) _gps.putc(cmd[i]);
}

void Venus838::setNavigationMode(const int mode) {
    char cmd[] = {
        0xA0, 0xA1, 0x00, 0x04,
        0x64, 0x17, 0x04, 0x01,
        0x00, 0x0D, 0x0A
    };
    for(int i = 4; i < 8; i++) cmd[8] ^= cmd[i];
    for(int i = 0; i < 10; i++) _gps.putc(cmd[i]);
}

bool Venus838::readable() {
    return _gps.readable();
}

void Venus838::putc(char in) {
    _gps.putc(in);
}

char Venus838::getc() {
    return _gps.getc();
}