#include "mbed.h"

Serial pc(USBTX, USBRX);
DigitalOut out(LED1);

void handleInput(char in);
void sing();

int main() {
    pc.printf("Ready!\n");
    while(true) {
        if(pc.readable()) {
            char in = pc.getc();
            handleInput(in);
        }
    }
}

void handleInput(char in) {
    switch(in) {
        case 'h':
        case 'H':
            out = 1;
            break;
        case 'l':
        case 'L':
            out = 0;
            break;
        case 's':
        case 'S':
            sing();
            break;
        default:
            pc.printf("I don't know: \"%c\"\n", in);
    }
}

void sing() {
    for(int i = 'a'; i <= 'z'; i++) {   // Loop through the alphabet
        pc.printf("%c", i);             // Say the letter
        wait(0.1);                      // Wait a bit
    }                                   // End the for loop
    pc.printf("\n");                    // Print a new line
}