#include "mbed.h"

// Global variables
DigitalOut led(LED1);           // LED output
Serial pc(USBTX, USBRX);        // Computer serial port

// Function prototypes
void handleInput(char in);

// Main function
int main() {
    while(true) {               // Main loop
        if(pc.readable()) {     // Can we read?
            char c = pc.getc(); // Read a character
            handleInput(c);     // Handle the input
        }
    }                           // Repeat
}

// Input handler
void handleInput(char in) {
    if(in == 'H') {             // Is input H?
        led = 1;                // Turn on LED
    } else if(in == 'L') {      // Is input L?
        led = 0;                // Turn off LED
    }
}