/* MS5611 Pressure sensor example
Aerodyne Labs
2014

This example uses the MS511 Library to read the temperature and pressure readings 
from the MS5611 sensor.  It has been modified from the MS507 sensor library with 
the different calculations that the MS5611 requires.  Otherwise, this library is
identical to the MS5607
*/
#include "mbed.h"

//Only uncomment the one needed.
//#include "MS5611SPI.h"
#include "MS5611I2C.h"

int main() {
    //Only uncomment the I2C or SPI version.
    //MS5611SPI ms5611(p11, p12, p13, p10);
    //MS5611I2C ms5611(p9, p10, false);
    //PB_9 and PB_8 for Nucleo boards
    MS5611I2C ms5611(PB_9, PB_8, false);
    //Print the Coefficients from the 
    ms5611.printCoefficients();
    printf("Pressure = %.0f Pa \r\n", ms5611.getPressure());
    printf("Temperature = %.2f degC \r\n", ms5611.getTemperature());
    printf("Altitude = %.2f m \r\n", ms5611.getAltitude());
}