#include "mbed.h"
#include "Atlas.h"
#include "SDFileSystem.h"

DigitalOut grn(LED_GRN);
DigitalOut ylw(LED_YLW);
Serial pc(USBTX, USBRX);
Serial gps(GPS_TX, GPS_RX);
SDFileSystem sd(SPI_MOSI, SPI_MISO, SPI_SCK, SPI_CS, "sd");

void init() {
    pc.baud(115200);
    gps.baud(115200);
    grn = LED_ON;
    ylw = LED_ON;
    
    printf("Attempting to open SD card...\n");
    mkdir("/sd/mydir", 0777);
    
    printf("Attempting to open file...\n");
    FILE *fp = fopen("/sd/mydir/sdtest.txt", "w");
    if(fp == NULL) {
        error("Could not open file for write\n");
        ylw = LED_OFF;
    }
    fprintf(fp, "Hello fun SD Card World!");
    
    printf("Closing file...\n");
    fclose(fp);
    
    pc.printf("Atlas Ready!\n");
}

int main() {
    init();
    while(true) {
        if(gps.readable()) {
            pc.putc(gps.getc());
        }
    }
}