#include "mbed.h"
#include "Atlas.h"
#include "SDFileSystem.h"
#include "Venus838.h"
#include "TinyGPS.h"
#include "MS5611I2C.h"

DigitalOut grn(LED_GRN);
DigitalOut ylw(LED_YLW);
AnalogIn    batt(PC_2);
Serial pc(USBTX, USBRX);
Venus838 venus(GPS_TX, GPS_RX);
TinyGPS gps;
MS5611I2C pres(I2C_SDA, I2C_SCL, false);
SDFileSystem sd(SPI_MOSI, SPI_MISO, SPI_SCK, SPI_CS, "sd");
Ticker tick;

unsigned int logCount = 0;

//Function to log data
void datalog(void)  {
    unsigned long date, time, ttf;
    double latitude, longitude, altitude;
    float pressure, temperature, battery;
    //unsigned int writeCount = 0;
    //unsigned int logCount = 0;
    
    grn = !grn;
    gps.get_datetime(&date, &time, &ttf);
    gps.f_get_position(&latitude, &longitude, &ttf);
    altitude = gps.f_altitude();
    pressure = pres.getPressure();
    temperature = pres.getTemperature();
    battery = (batt.read()*3.3f) * 4.0f;
    //wait_ms(1); 
    pc.printf("%u, %u, %u, %f, %f, %f, %f, %f, %f\r\n",
        logCount, date, time, longitude, latitude, altitude,
        pressure, temperature, battery);
    FILE *fp = fopen("/sd/atlas.txt", "a");
    fprintf(fp, "%u, %u, %u, %f, %f, %f, %f, %f %f\r\n",
        logCount, date, time, longitude, latitude, altitude,
        pressure, temperature, battery);
    logCount++;
    fclose(fp);    
}

void init() {
    pc.baud(115200);
    grn = LED_OFF;
    ylw = LED_OFF;
    printf("Configuring Venus GPS...\r\n");
    //venus.setUpdateRate(1);
    venus.setNavigationMode(4);
    venus.setNmeaMessages(true, false, false, false, true, false);
    
    printf("Attempting to open SD card...\r\n");
    mkdir("/sd/debug", 0777);
    
    printf("Attempting to open file...\r\n");
    FILE *fp = fopen("/sd/debug/debug.txt", "w");
    if(fp == NULL) {
        error("Could not open file for write\r\n");
        ylw = LED_ON;
    }
    fprintf(fp, "Atlas Debug File\r\n");
    fprintf(fp, "====================\r\n");
    fprintf(fp, "Atlas Firmware: 0.1\r\n");
    //TODO Add calls to query GPS for fimrware and other info
    fprintf(fp, "GPS Firmware:   Update rate:   Mode:   \r\n");
    //fprintf(fp, pres.printCoefficients());
    printf("Closing file...\r\n");
    fclose(fp);
    
    pres.printCoefficients();
    
    //tick.start();
    pc.printf("Atlas Ready!\r\n");
}

int main() {
    
    init();
    tick.attach(&datalog,1.0);
    FILE *fp = fopen("/sd/atlas.txt", "a");
    fprintf(fp, "Atlas Logger\r\n");
    fprintf(fp, "Count  Date   Time    Lon     Lat     Alt     Pressure    Temp    Battery\r\n");
    fprintf(fp, "-------------------------------------------------------------------------\r\n");
    fclose(fp);
    while(true) {
        if(venus.readable()) {
            char c = venus.getc();
            //pc.putc(c);
            gps.encode(c);
        }
        
/*
        if(tick.read_ms() >= 500) {
            tick.reset();
            grn = !grn;
            gps.get_datetime(&date, &time, &ttf);
            gps.f_get_position(&latitude, &longitude, &ttf);
            altitude = gps.f_altitude();
            pressure = pres.getPressure();
            temperature = pres.getTemperature();
            battery = (batt.read()*3.3f) * 4.0f;
            wait_ms(1); 
            pc.printf("%u %u, %u, %f, %f, %f, %f, %f, %f\r\n",
                logCount, date, time, longitude, latitude, altitude,
                pressure, temperature, battery
            );
            FILE *fp = fopen("/sd/atlas.txt", "a");
            fprintf(fp, "%u %u, %u, %f, %f, %f, %f, %f %f\r\n",
                logCount, date, time, longitude, latitude, altitude,
                pressure, temperature, battery
            );
            logCount++;
            fclose(fp);
            writeCount++;
                if(writeCount > 100) {
                    writeCount = 0;
                    fclose(fp);
                    FILE *fp = fopen("/sd/atlas.txt", "a");
                }
        }
*/
    }
}