#include "mbed.h"
#include<string>
//LED
PwmOut stm_led(LED1);
//Bluetooth
Serial bluetooth(PB_6,PA_10);
Serial pc(SERIAL_TX, SERIAL_RX);

DigitalOut bt_pair(PA_7);
DigitalOut bt_reset(PC_7);

Timer timeout;
char responseBuff[4];
char responseOk[4] = {'\r','\n','K','O'};

bool bluetooth_command(string command){
    pc.printf("SENDING {%s}\r",command);
    bluetooth.printf("%s\r",command);
    timeout.reset();
    timeout.start();
    while(timeout.read_ms()<2000){
        if(memcmp(&responseOk[0],&responseBuff[0],4) == 0){
            pc.printf("%d ms\r",timeout.read_ms());
            timeout.stop();
            //Shift buffer by one to insure previous responses don't interfere
            for(int z=2;z>0;z--){
                responseBuff[z+1]=responseBuff[z];
            }
            responseBuff[1]=responseBuff[0];
            responseBuff[0]=0;
            return true;
        }    
    }
    timeout.stop();
    return false;
}

void ledBlink(int blinks,int delay){
    for(int i=2*blinks; i>0; i--){
        stm_led = !stm_led;
        wait_ms(delay);
    }
}

void bluetoothInitializer(){
    bt_reset = 0;
    wait(0.5);
    bt_reset = 1;
    wait(0.5);
    bt_pair =1;
    wait(0.5);
    bt_pair =0;
    wait(0.5);
    bluetooth.baud(9600);
    wait(.1);
}
void readResponse(){
    for(int z=2;z>0;z--){
        responseBuff[z+1]=responseBuff[z];
    }
    responseBuff[1]=responseBuff[0];
    responseBuff[0]=bluetooth.getc();
    pc.putc(responseBuff[0]);
}

void writeResponse(){
    bluetooth.putc(pc.getc());
}
int main() {
    bluetoothInitializer();
    bluetooth.attach(&readResponse);
    pc.attach(&writeResponse);
    wait(5);
    pc.printf("Starting\r");
    bool debug=true;
    stm_led=1;
    wait(1);
    pc.printf("Atempting to send command\r");
    wait(1);
    bluetooth_command("RESTORE");
    debug&=bluetooth_command("SET NAME=BC127 BLE");
    debug&=bluetooth_command("SET NAME_SHORT=BCBLE");
    debug&=bluetooth_command("SET ENABLE_SPP=ON");
    debug&=bluetooth_command("SET ENABLE_IAP=OFF");
    debug&=bluetooth_command("SET ENABLE_IAP_V2=OFF");
    debug&=bluetooth_command("SET ENABLE_MAP=OFF");
    debug&=bluetooth_command("SET BLE_ROLE=1");
    debug&=bluetooth_command("ADVERTISING ON");
    debug&=bluetooth_command("WRITE");
    bluetooth_command("RESET");
    wait(.1);
    pc.printf("Finished sending commands\r");
    bluetooth.printf("config\r");
    while(1) {
        if(debug==true){
        stm_led=!stm_led;
        wait(2);
        }
    }
}