#include "LSM9DS1.h"

void timerInterrupt();

DigitalOut myled(LED1);
Serial pc(USBTX, USBRX);

Ticker timer1;
#define PERIOD 10000 // unit: us

// IMU in SPI mode
SPI imuSpi(PC_12, PC_11, PC_10); // MOSI, MISO, SCLK
DigitalOut agCS(PA_13);
DigitalOut mCS(PA_14);
LSM9DS1 imu(&imuSpi, &agCS, &mCS, 0xD6, 0x3C);

float degree = 0.0f;

int main() {
        
    pc.baud(115200);
    
    pc.printf("Start LSM9DS1\n\r");
        
    bool status = imu.begin();
    pc.printf("connect or not: %d\n\r", status);
    
    imu.calibrate();
    wait(1);    
    
    timer1.attach_us(&timerInterrupt, PERIOD);
    
    while(1) {
        
        pc.printf("gz: %.3f  gzBias: %.3f  degree: %.3f \n\r", imu.gz, imu.gBias[2], degree);
               
        wait(0.01);
    }
}

void timerInterrupt()
{
    imu.readGyro();
        
    degree += imu.gz * PERIOD / 1000000.0f;
}