#include "LSM9DS1.h"
#include <vector>
using std::vector;

DigitalOut myled(LED1);
Serial pc(USBTX, USBRX);

int main() {
    //LSM9DS1 lol(D14, D15, 0x6B, 0x1E);
    LSM9DS1 lol(D14, D15, 0xD6, 0x3C);
    
    vector<float> gyro(3, 0.0);
    vector<float> accel(3, 0.0);
    
    lol.begin();
    if (!lol.begin()) {
        pc.printf("Failed to communicate with LSM9DS1.\n");
    }
    lol.calibrate();
    
    while(1) {
        
        lol.readGyroFloatVectorDeg(gyro);
        lol.readAccelFloatVector(accel);
        
        
        pc.printf("gyro: %.3f %.3f %.3f\n\r", gyro[X_AXIS], gyro[Y_AXIS], gyro[Z_AXIS]);
        //pc.printf("accel: %f %f %f\n\n\r", accel[X_AXIS], accel[Y_AXIS], accel[Z_AXIS]);
        
    }
}
