/*==============================================================================
* Hotkey channel switcher                                                      *
* Sends hotkeys to switch channels on Infinity-like systems, then types        *
* 
==============================================================================*/
 
 
#include "mbed.h"
#include "C12832.h"
#include "USBKeyboard.h"
#include <string>
 
 
BusOut leds(p23, p24, p25);
C12832 lcd(p5, p7, p6, p8, p11);
USBKeyboard keyboard;
 
const float delay = 0.1;
int count = 1;

const int ccs_hotkeys = KEY_CTRL | KEY_ALT;
int ccs_base = 1;
//const int ccs_end = 8;
const int ccs_end = 4;
char ccs_mod;

const int alif_hotkeys = KEY_CTRL | KEY_SHIFT;
int alif_base = 1;
const int alif_end = 4;
char alif_mod;

const float speed = 5;

string info;
 
static void sendKey(char c, int modifiers, float delay)
{
    keyboard.keyCode(c, modifiers);
    wait(delay);
}

//Display general status information
void printData(string info, int key2) {
    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("Sending %s+%c \n", info.c_str(), key2);
}

// Switch the CCS PRO 'Computer' setting.
void switchCCSPRO(void)
{
    int ccsID;

    //setup and open next connection
    ccsID = (rand() % ccs_end) + 1;
    ccs_mod = '0'+ccsID;
    leds = ~ccs_base;
    sendKey(ccs_mod, ccs_hotkeys, delay);
    printData("Ctrl+Alt", ccs_mod);
}

// Switch between random number of ALIFs (channels)
void switchALIFs(void)
{
    int i;
    int alifID;
    int wIndex;
    
    int wMS[12] = {850,100,500,250,1000,300,750,450,2000,800,650,1500};
    int numOfSwitches = (rand() % 10) + 1;
    
    for(i=1; i <= numOfSwitches; i++)
    {
        alifID = (rand() % alif_end) + 1;
        alif_mod = '0'+alifID;
        sendKey(alif_mod, alif_hotkeys, delay);
        printData("Ctrl+Shift", alif_mod);
        
        wIndex = rand() % 12;
        wait_ms(wMS[wIndex]);
    }
}
 
int main(void)
{
    // Startup initialisation.
    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("Starting Up RTLX6,\nAllowing USB to settle\n>>Please Wait<< ");
    wait(10);
    srand(time(NULL));
       
    int switchType;
    float waitCCS;
    
    // Main loop.
    while (1) {
               
        switchType = rand() % 2;
        
        if (switchType == 0)
        {
            switchCCSPRO();
        }
        else
        {
            switchALIFs();
            // Disconnect.
            sendKey('x', alif_hotkeys, delay);
        }
        
        waitCCS = (rand() % 5) + 1;
        wait(waitCCS);
    }
}
