/****************************************************************************
- Following program is to emulate Infinity channel switching.
- embeds are used to send hotkey combination to switch channel. 
- CTRL+SHIFT+[1-4] is used to switch among four channels.
- LCD screen on mbed application board is used to show switch status and count.

****************************************************************************/

//imports
#include "mbed.h"
#include "C12832.h"
#include "USBKeyboard.h"

// To change LED colour at channel switching
BusOut leds(p23, p24, p25);
BusOut myleds(LED1, LED2, LED3, LED4);

// keyboard interface to emulate keyboard and send keys with modifiers
USBKeyboard keyboard;

// LCD interface on appication board
C12832 lcd(p5, p7, p6, p8, p11);

// Switching period: 'every <speed> seconds'
const float speed = 10.0;
const int hotkeys = KEY_CTRL | KEY_RALT;
const int max_channel = 9;

//print to lcd screen while channel switching
void lcd_print_switching(int key, int total, float speed, int sets) {
    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("Sending CTRL+RALT+%c \nCount: %d, Sets: %d\nSpeed: %4.2f seconds\n", key, total, sets, speed);
}

// Start programme
int main(void) {
    
    int key_base; // channel number
    int count = 0; // Cumulative channel switching count
    int sets = 0; // Cumulative channel switching sets
    char key_modifier; 
    
    //Disconnect any existing connections
    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("Starting Up..\nAllowing USB to settle\n>>Please Wait<< ");
    wait(10);
 
    // Loop forever
    while(1) {
        
        key_base = 0;
        
        while(key_base <= max_channel) {
            lcd.cls();
            leds = ~key_base;
            myleds = key_base;
            key_modifier = '0'+key_base; //turn to ascii value
            keyboard.keyCode(key_modifier, hotkeys);
            count++;
            lcd_print_switching(key_modifier, count, speed, sets);
            key_base++;
            wait(speed);
        }
        sets++;              
    }
}
