/***
**** ST M24512 512-Kbit I2C EEPROM
**** E0-E2 pulled low
**** 10k pull up resistors on SDA and SCL lines
***/
#include "mbed.h"

#define EEPROM_ADDR   (0b10100000) // EEPROM address

I2C i2c(I2C_SDA, I2C_SCL);
DigitalIn mybutton(USER_BUTTON); // Activate button
Serial pc(SERIAL_TX, SERIAL_RX); // Initialize UART connection
// Use a terminal program (eg. putty)!

int main()
{
    pc.printf("Read data from EEPROM sequentially\r\n");
    char data[1];
    char data_write[3]; //Array for address and data
    // Type in address
    data_write[0] = 0;
    data_write[1] = 0;
    // Type data
    data_write[2] = 1;
    uint8_t i;
    for( i=0; i < 255; i++ ) {
        data_write[1] = i;
        data_write[2] = i;
        i2c.write(EEPROM_ADDR, data_write, 3);
        wait_ms(6); // Wait eeprom internal write cycle (5ms) + 1ms
    }
    // Reset eeprom pointer address
    char eeprom_address[2] = {0, 0};
    i2c.write(EEPROM_ADDR, eeprom_address, 2, true);
    i2c.read(EEPROM_ADDR, data, 1, false);
    pc.printf("Written data: %d\n\r",data[0]);

    while (1) {
        if (mybutton == 0) { // Button is pressed
            i2c.read(EEPROM_ADDR, data, 1);
            pc.printf("%d\n\r",data[0]);
            wait_ms(500);
        }
    }

}