#include "mbed.h"

DigitalOut myled(LED1); // Activate LED
DigitalIn mybutton(USER_BUTTON); // Activate button
DigitalInOut data_pin(A0); // Activate digital in
Serial pc(SERIAL_TX, SERIAL_RX); // Initialize UART connection
// Use a terminal program (eg. TeraTerm).
Timer tmr; //initialize timer
uint64_t adat; // 64 bit variable for temporary data
int i;

// Function to initialize DHT11
void dht_read(void) {
    data_pin.output(); // Set A0 as output
    // Initialize measurement > 18 ms low
    data_pin = 0;
    wait_ms(20);
    // After high and release the pin switch input mode
    data_pin = 1;
    data_pin.input();
    // Wait until the end of 80 us low
    while(!data_pin.read()) {}
    // Wait until end of 80 us high
    while(data_pin.read()) {}
    // 40 bit, 40 read out cycle
    for(i=0; i<40; i++) {
        adat = adat << 1; // Shift for new number
        tmr.stop(); // Stop timer if runs
        tmr.reset();  // Reset timer
        // Wait until pin
        while(!data_pin.read()) {}          
        tmr.start();            
        while(data_pin.read()) {}
        // If DHT11 HIGH longer than 40 micro seconds (hopefully 70 us)
        if(tmr.read_us() > 40) {
            // bit is 1
            adat++;
        }
    }
}

int main() {
    pc.printf("Read the DHT11 temperature and humidity sensor!\n"); //Welcome message
    while(1) {
        if (mybutton == 0) { // Button is pressed
            // Reset adat variable
            adat = 0;
            myled = 1; // LED is ON
            dht_read(); // Call the function
            // Send result through UART result
            pc.printf("Humidity: "); // Humidity
            pc.printf("%d", (adat  & 0x000000ff00000000) >> 32); // Humidity
            pc.printf("\n\r"); // Send a new line and carriage return.
            pc.printf("%d", (adat & 0x0000000000ff0000) >> 16 ); // Temperature
            pc.printf("\n\r");
            pc.printf("%d", adat & 0x00000000000000ff); // Checksum.
            pc.printf("\n\r");
            wait_ms(200); // Wait 0.2 sec till continue.
        } else {
            myled = 0; // LED is OFF
        }
    }
}
